/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.jupyter;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.jupyter.JupyterCell;
import org.testingisdocumenting.znai.jupyter.JupyterCellFilter;
import org.testingisdocumenting.znai.jupyter.JupyterNotebook;
import org.testingisdocumenting.znai.jupyter.JupyterOutput;
import org.testingisdocumenting.znai.jupyter.JupyterParserVer4;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class JupyterIncludePlugin
implements IncludePlugin {
    private static final String STORY_FIRST_KEY = "storyFirst";
    private static final String INCLUDE_SECTION_KEY = "includeSection";
    private static final String EXCLUDE_SECTION_TITLE_KEY = "excludeSectionTitle";
    private MarkdownParser markdownParser;
    private Path path;
    private String lang;
    private boolean isStoryFirst;
    private ParserHandler markdownParserHandler;

    @Override
    public String id() {
        return "jupyter";
    }

    @Override
    public IncludePlugin create() {
        return new JupyterIncludePlugin();
    }

    @Override
    public PluginParamsDefinition parameters() {
        PluginParamsDefinition params = new PluginParamsDefinition();
        params.add(STORY_FIRST_KEY, PluginParamType.BOOLEAN, "put output cells first, before input", "true");
        params.add(INCLUDE_SECTION_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "only include specified section by title", "Example of Data setup");
        params.add(EXCLUDE_SECTION_TITLE_KEY, PluginParamType.BOOLEAN, "when include section key is used, excludes the matched title", "true");
        return params;
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.markdownParser = componentsRegistry.markdownParser();
        this.markdownParserHandler = parserHandler;
        this.isStoryFirst = pluginParams.getOpts().get(STORY_FIRST_KEY, false);
        List<String> includeSection = pluginParams.getOpts().getList(INCLUDE_SECTION_KEY);
        Boolean excludeSectionTitle = pluginParams.getOpts().get(EXCLUDE_SECTION_TITLE_KEY, false);
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        this.path = resourcesResolver.fullPath(pluginParams.getFreeParam());
        JupyterNotebook notebook = new JupyterParserVer4().parse(JsonUtils.deserializeAsMap(resourcesResolver.textContent(this.path)));
        this.lang = notebook.getLang();
        List<JupyterCell> cells = !includeSection.isEmpty() ? this.collectCells(notebook.getCells(), includeSection, excludeSectionTitle) : notebook.getCells();
        cells.forEach(this::processCell);
        return PluginResult.docElements(Stream.empty());
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.path));
    }

    private List<JupyterCell> collectCells(List<JupyterCell> cells, List<String> includeSections, Boolean excludeSectionTitle) {
        ArrayList<JupyterCell> result = new ArrayList<JupyterCell>();
        for (String includeSection : includeSections) {
            List<JupyterCell> filtered = JupyterCellFilter.fromSection(cells, includeSection, excludeSectionTitle);
            if (filtered.isEmpty()) {
                throw new RuntimeException("No cells found for include section: \"" + includeSection + "\"");
            }
            result.addAll(filtered);
        }
        return result;
    }

    private void processCell(JupyterCell cell) {
        this.processMarkdownCell(cell);
        if (this.isStoryFirst) {
            this.processOutputFromCell(cell);
            this.processInputFromCell(cell);
        } else {
            this.processInputFromCell(cell);
            this.processOutputFromCell(cell);
        }
    }

    private void processMarkdownCell(JupyterCell cell) {
        if (!cell.getType().equals("markdown")) {
            return;
        }
        this.markdownParser.parse(this.path, this.markdownParserHandler, cell.getInput());
    }

    private void processInputFromCell(JupyterCell cell) {
        if (this.isMarkdown(cell)) {
            return;
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("cellType", cell.getType());
        props.putAll(this.convertInputData(cell));
        if (this.isStoryFirst) {
            props.putAll(this.createMetaRight());
        }
        this.addCell(props);
    }

    private void processOutputFromCell(JupyterCell cell) {
        if (cell.getOutputs().isEmpty()) {
            this.processEmptyOutput();
        } else {
            cell.getOutputs().forEach(this::processCellOutput);
        }
    }

    private void processCellOutput(JupyterOutput output) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("cellType", "output");
        props.putAll(this.convertOutputData(output));
        if (!this.isStoryFirst) {
            props.putAll(this.createMetaRight());
        }
        this.addCell(props);
    }

    private void processEmptyOutput() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("cellType", "empty-output");
        props.putAll(this.createMetaRight());
        this.addCell(props);
    }

    private void addCell(Map<String, ?> props) {
        this.markdownParserHandler.onCustomNode("JupyterCell", props);
    }

    private boolean isMarkdown(JupyterCell cell) {
        return cell.getType().equals("markdown");
    }

    private Map<String, ?> createMetaRight() {
        LinkedHashMap<String, Boolean> meta = new LinkedHashMap<String, Boolean>();
        meta.put("rightSide", true);
        return Collections.singletonMap("meta", meta);
    }

    private Map<String, Object> convertInputData(JupyterCell cell) {
        if (cell.getType().equals("code")) {
            return CodeSnippetsProps.create(this.lang, cell.getInput());
        }
        return Collections.singletonMap("text", cell.getInput());
    }

    private Map<String, Object> convertOutputData(JupyterOutput output) {
        return Collections.singletonMap(output.getFormat(), output.getContent());
    }
}

