/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.commonmark;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamValidationResult;
import org.testingisdocumenting.znai.extensions.PluginParamWarning;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsFactory;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.Plugins;
import org.testingisdocumenting.znai.extensions.PluginsRegexp;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.extensions.footnote.FootnoteId;
import org.testingisdocumenting.znai.extensions.footnote.ParsedFootnote;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.extensions.inlinedcode.InlinedCodePlugin;
import org.testingisdocumenting.znai.extensions.latex.LatexDollarBlock;
import org.testingisdocumenting.znai.extensions.latex.LatexDollarInline;
import org.testingisdocumenting.znai.parser.HeadingProps;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.commonmark.HeadingTextAndProps;
import org.testingisdocumenting.znai.parser.commonmark.ValidateOnlyAllowedSyntaxInHeadingVisitor;
import org.testingisdocumenting.znai.parser.commonmark.include.IncludeBlock;
import org.testingisdocumenting.znai.parser.docelement.DocElementCreationParserHandler;
import org.testingisdocumenting.znai.parser.table.GfmTableToTableConverter;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.utils.JsonUtils;
import znaishaded.org.commonmark.ext.footnotes.FootnoteDefinition;
import znaishaded.org.commonmark.ext.footnotes.FootnoteReference;
import znaishaded.org.commonmark.ext.front.matter.YamlFrontMatterBlock;
import znaishaded.org.commonmark.ext.gfm.strikethrough.Strikethrough;
import znaishaded.org.commonmark.ext.gfm.tables.TableBlock;
import znaishaded.org.commonmark.node.AbstractVisitor;
import znaishaded.org.commonmark.node.BlockQuote;
import znaishaded.org.commonmark.node.BulletList;
import znaishaded.org.commonmark.node.Code;
import znaishaded.org.commonmark.node.CustomBlock;
import znaishaded.org.commonmark.node.CustomNode;
import znaishaded.org.commonmark.node.Emphasis;
import znaishaded.org.commonmark.node.FencedCodeBlock;
import znaishaded.org.commonmark.node.HardLineBreak;
import znaishaded.org.commonmark.node.Heading;
import znaishaded.org.commonmark.node.HtmlBlock;
import znaishaded.org.commonmark.node.HtmlInline;
import znaishaded.org.commonmark.node.Image;
import znaishaded.org.commonmark.node.IndentedCodeBlock;
import znaishaded.org.commonmark.node.Link;
import znaishaded.org.commonmark.node.ListItem;
import znaishaded.org.commonmark.node.Node;
import znaishaded.org.commonmark.node.OrderedList;
import znaishaded.org.commonmark.node.Paragraph;
import znaishaded.org.commonmark.node.SoftLineBreak;
import znaishaded.org.commonmark.node.StrongEmphasis;
import znaishaded.org.commonmark.node.Text;
import znaishaded.org.commonmark.node.ThematicBreak;

public class MarkdownVisitor
extends AbstractVisitor {
    private final ComponentsRegistry componentsRegistry;
    private final Path path;
    private final ParserHandler parserHandler;
    private boolean sectionStarted;
    private final Set<PluginParamWarning> parameterWarnings;

    public MarkdownVisitor(ComponentsRegistry componentsRegistry, Path path, ParserHandler parserHandler) {
        this.componentsRegistry = componentsRegistry;
        this.path = path;
        this.parserHandler = parserHandler;
        this.parameterWarnings = new LinkedHashSet<PluginParamWarning>();
    }

    public boolean isSectionStarted() {
        return this.sectionStarted;
    }

    public boolean hasPluginWarnings() {
        return !this.parameterWarnings.isEmpty();
    }

    public Set<PluginParamWarning> getParameterWarnings() {
        return this.parameterWarnings;
    }

    @Override
    public void visit(Paragraph paragraph) {
        this.parserHandler.onParagraphStart();
        this.visitChildren(paragraph);
        this.parserHandler.onParagraphEnd();
    }

    @Override
    public void visit(Emphasis emphasis) {
        this.parserHandler.onEmphasisStart();
        this.visitChildren(emphasis);
        this.parserHandler.onEmphasisEnd();
    }

    @Override
    public void visit(StrongEmphasis strongEmphasis) {
        this.parserHandler.onStrongEmphasisStart();
        this.visitChildren(strongEmphasis);
        this.parserHandler.onStrongEmphasisEnd();
    }

    @Override
    public void visit(Text text) {
        this.parserHandler.onSimpleText(text.getLiteral());
    }

    @Override
    public void visit(BulletList bulletList) {
        this.parserHandler.onBulletListStart(bulletList.getBulletMarker(), bulletList.isTight());
        this.visitChildren(bulletList);
        this.parserHandler.onBulletListEnd();
    }

    @Override
    public void visit(OrderedList orderedList) {
        this.parserHandler.onOrderedListStart(orderedList.getDelimiter(), orderedList.getStartNumber());
        this.visitChildren(orderedList);
        this.parserHandler.onOrderedListEnd();
    }

    @Override
    public void visit(ListItem listItem) {
        this.parserHandler.onListItemStart();
        this.visitChildren(listItem);
        this.parserHandler.onListItemEnd();
    }

    @Override
    public void visit(Code code) {
        String literal = code.getLiteral();
        PluginsRegexp.IdAndParams idAndParams = PluginsRegexp.parseInlinedCodePlugin(literal);
        if (idAndParams != null) {
            this.handleInlineCodePlugin(this.componentsRegistry.pluginParamsFactory().create(idAndParams.getId(), idAndParams.getParams()));
        } else {
            this.parserHandler.onInlinedCode(literal, DocReferences.EMPTY);
        }
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        this.parserHandler.onThematicBreak();
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        this.parserHandler.onHardLineBreak();
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        this.parserHandler.onSoftLineBreak();
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        this.parserHandler.onBlockQuoteStart();
        this.visitChildren(blockQuote);
        this.parserHandler.onBlockQuoteEnd();
    }

    @Override
    public void visit(CustomBlock customBlock) {
        if (customBlock instanceof YamlFrontMatterBlock) {
            return;
        }
        if (customBlock instanceof IncludeBlock) {
            IncludeBlock includeBlock = (IncludeBlock)customBlock;
            this.handleIncludePlugin(includeBlock.getParams());
        } else if (customBlock instanceof TableBlock) {
            GfmTableToTableConverter gfmTableToTableConverter = new GfmTableToTableConverter(this.componentsRegistry, this.path, (TableBlock)customBlock);
            this.parserHandler.onTable(gfmTableToTableConverter.convert());
        } else if (customBlock instanceof FootnoteDefinition) {
            FootnoteDefinition footnote = (FootnoteDefinition)customBlock;
            ParsedFootnote parsed = ParsedFootnote.parse(this.componentsRegistry, this.path, footnote);
            this.parserHandler.onFootnoteDefinition(parsed);
        } else {
            throw new UnsupportedOperationException("unsupported custom block: " + String.valueOf(customBlock));
        }
    }

    @Override
    public void visit(CustomNode customNode) {
        if (customNode instanceof Strikethrough) {
            this.parserHandler.onStrikeThroughStart();
            this.visitChildren(customNode);
            this.parserHandler.onStrikeThroughEnd();
        } else if (customNode instanceof LatexDollarInline) {
            LatexDollarInline dollarInline = (LatexDollarInline)customNode;
            this.handleInlineCodePlugin(this.componentsRegistry.pluginParamsFactory().create("latex", "", Collections.singletonMap("src", dollarInline.getLiteral())));
        } else if (customNode instanceof LatexDollarBlock) {
            LatexDollarBlock dollarBlock = (LatexDollarBlock)customNode;
            this.handleFencePlugin(this.componentsRegistry.pluginParamsFactory().create("latex", "", Collections.emptyMap()), dollarBlock.getLiteral());
        } else if (customNode instanceof FootnoteReference) {
            FootnoteReference reference = (FootnoteReference)customNode;
            this.parserHandler.onFootnoteReference(new FootnoteId(reference.getLabel()));
        } else {
            super.visit(customNode);
        }
    }

    @Override
    public void visit(Image image) {
        Node firstChild = image.getFirstChild();
        String alt = this.extractText(firstChild);
        this.parserHandler.onImage(image.getTitle(), image.getDestination(), alt.isEmpty() ? "image" : alt);
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        this.parserHandler.onSnippet(PluginParams.EMPTY, "", "", indentedCodeBlock.getLiteral());
    }

    @Override
    public void visit(FencedCodeBlock fencedCodeBlock) {
        PluginParams pluginParams = this.extractFencePluginParams(fencedCodeBlock.getInfo().trim());
        if (Plugins.hasFencePlugin(pluginParams.getPluginId())) {
            this.handleFencePlugin(pluginParams, fencedCodeBlock.getLiteral());
        } else {
            this.parserHandler.onSnippet(pluginParams, pluginParams.getPluginId(), "", fencedCodeBlock.getLiteral());
        }
    }

    @Override
    public void visit(Link link) {
        this.parserHandler.onLinkStart(link.getDestination());
        this.visitChildren(link);
        this.parserHandler.onLinkEnd();
    }

    @Override
    public void visit(Heading heading) {
        HeadingTextAndProps headingTextAndProps = this.extractHeadingTextAndProps(heading);
        if (heading.getLevel() == 1) {
            if (this.sectionStarted) {
                this.parserHandler.onSectionEnd();
            }
            this.parserHandler.onSectionStart(headingTextAndProps.text(), headingTextAndProps.props(), heading);
            this.sectionStarted = true;
        } else {
            this.parserHandler.onSubHeading(heading.getLevel(), headingTextAndProps.text(), headingTextAndProps.props(), heading);
        }
    }

    @Override
    public void visit(HtmlInline htmlInline) {
        if (!htmlInline.getLiteral().equals("<br>")) {
            throw new UnsupportedOperationException("inlined html is not supported: " + htmlInline.getLiteral());
        }
        this.parserHandler.onHtml(htmlInline.getLiteral(), true);
    }

    @Override
    public void visit(HtmlBlock htmlBlock) {
        this.parserHandler.onHtml(htmlBlock.getLiteral(), false);
    }

    private void handleIncludePlugin(PluginParams params) {
        try {
            IncludePlugin includePlugin = Plugins.includePluginById(params.getPluginId());
            includePlugin.preprocess(this.componentsRegistry, this.path, params);
            PluginParamValidationResult validationResult = includePlugin.parameters().validateParamsAndHandleRenames(params);
            this.handleParamsValidationResult(validationResult);
            PluginResult pluginResult = includePlugin.process(this.componentsRegistry, this.parserHandler, this.path, params);
            this.parserHandler.onIncludePlugin(includePlugin, pluginResult);
        }
        catch (Exception e) {
            throw new RuntimeException(MarkdownVisitor.createPluginErrorMessage("include", params, e), e);
        }
    }

    private void handleFencePlugin(PluginParams params, String fenceContent) {
        try {
            FencePlugin fencePlugin = Plugins.fencePluginById(params.getPluginId());
            fencePlugin.preprocess(this.componentsRegistry, this.path, params);
            fencePlugin.preprocess(this.componentsRegistry, this.path, params, fenceContent);
            PluginParamValidationResult validationResult = fencePlugin.parameters().validateParamsAndHandleRenames(params);
            this.handleParamsValidationResult(validationResult);
            PluginResult pluginResult = fencePlugin.process(this.componentsRegistry, this.path, params, fenceContent);
            this.parserHandler.onFencePlugin(fencePlugin, pluginResult);
        }
        catch (Exception e) {
            throw new RuntimeException(MarkdownVisitor.createPluginErrorMessage("fence", params, e) + "\n  fence content:\n" + fenceContent, e);
        }
    }

    private void handleInlineCodePlugin(PluginParams params) {
        try {
            InlinedCodePlugin inlinedCodePlugin = Plugins.inlinedCodePluginById(params.getPluginId());
            inlinedCodePlugin.preprocess(this.componentsRegistry, this.path, params);
            PluginParamValidationResult validationResult = inlinedCodePlugin.parameters().validateParamsAndHandleRenames(params);
            this.handleParamsValidationResult(validationResult);
            PluginResult pluginResult = inlinedCodePlugin.process(this.componentsRegistry, this.path, params);
            this.parserHandler.onInlinedCodePlugin(inlinedCodePlugin, pluginResult);
        }
        catch (Exception e) {
            throw new RuntimeException(MarkdownVisitor.createPluginErrorMessage("inline code", params, e), e);
        }
    }

    private static String createPluginErrorMessage(String pluginType, PluginParams params, Exception e) {
        return "error handling " + pluginType + " plugin <" + params.getPluginId() + ">\n  free param: " + params.getFreeParam() + "\n  opts: " + JsonUtils.serialize(params.getOpts().toMap()) + "\n\n" + e.getMessage() + "\n";
    }

    private PluginParams extractFencePluginParams(String nameAndParams) {
        PluginParamsFactory pluginParamsFactory = this.componentsRegistry.pluginParamsFactory();
        int firstSpaceIdx = nameAndParams.indexOf(32);
        return firstSpaceIdx == -1 ? pluginParamsFactory.create(nameAndParams, "") : pluginParamsFactory.create(nameAndParams.substring(0, firstSpaceIdx), nameAndParams.substring(firstSpaceIdx + 1));
    }

    private void handleParamsValidationResult(PluginParamValidationResult validationResult) {
        if (!validationResult.isValid()) {
            throw new IllegalArgumentException(validationResult.getValidationError());
        }
        this.parameterWarnings.addAll(validationResult.getWarnings());
    }

    private HeadingTextAndProps extractHeadingTextAndProps(Heading heading) {
        heading.accept(ValidateOnlyAllowedSyntaxInHeadingVisitor.INSTANCE);
        final DocElementCreationParserHandler parserHandler = new DocElementCreationParserHandler(this.componentsRegistry, this.path);
        final ArrayList textParts = new ArrayList();
        heading.accept(new AbstractVisitor(){

            @Override
            public void visit(Text text) {
                HeadingTextAndProps headingTextAndProps = HeadingTextAndProps.extractTextAndProps(text.getLiteral());
                textParts.add(headingTextAndProps.text());
            }

            @Override
            public void visit(Code code) {
                textParts.add(code.getLiteral());
                parserHandler.onInlinedCode(code.getLiteral(), DocReferences.EMPTY);
            }
        });
        String combinedText = String.join((CharSequence)"", textParts).trim();
        Node lastChild = heading.getLastChild();
        if (lastChild instanceof Text) {
            Text textNode = (Text)lastChild;
            HeadingTextAndProps headingTextAndProps = HeadingTextAndProps.extractTextAndProps(textNode.getLiteral());
            return new HeadingTextAndProps(combinedText, headingTextAndProps.props());
        }
        return new HeadingTextAndProps(combinedText, HeadingProps.EMPTY);
    }

    private String extractText(Node node) {
        if (node == null) {
            return "";
        }
        return ((Text)node).getLiteral().trim();
    }
}

