/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import org.testingisdocumenting.znai.extensions.file.ManipulatedSnippetContentProvider;
import org.testingisdocumenting.znai.extensions.file.SnippetAutoTitleFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetHighlightFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetRevealLineStopFeature;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.python.PythonIncludePluginBase;
import org.testingisdocumenting.znai.python.PythonIncludeResult;
import org.testingisdocumenting.znai.python.PythonParsedEntry;
import org.testingisdocumenting.znai.python.PythonParsedFile;

public class PythonIncludePlugin
extends PythonIncludePluginBase {
    private boolean isBodyOnly;

    @Override
    public String id() {
        return "python";
    }

    @Override
    public IncludePlugin create() {
        return new PythonIncludePlugin();
    }

    @Override
    public PythonIncludeResult process(PythonParsedFile parsed, ParserHandler parserHandler, Path markupPath) {
        this.isBodyOnly = this.pluginParams.getOpts().get("bodyOnly", false);
        PythonParsedEntry codeEntry = this.findEntryByName(parsed, this.getEntryName());
        ManipulatedSnippetContentProvider contentProvider = new ManipulatedSnippetContentProvider(this.snippetIdToUse(), this.extractContent(codeEntry), this.pluginParams);
        this.features.add(new SnippetAutoTitleFeature(contentProvider.snippetId()));
        this.features.add(new SnippetHighlightFeature(this.componentsRegistry, this.pluginParams, contentProvider));
        this.features.add(new SnippetRevealLineStopFeature(this.pluginParams, contentProvider));
        Map<String, Object> props = CodeSnippetsProps.create("python", contentProvider.snippetContent());
        props.putAll(this.pluginParams.getOpts().toMap());
        this.features.updateProps(props);
        DocElement docElement = new DocElement("Snippet");
        docElement.addProps(props);
        return new PythonIncludeResult(Collections.singletonList(docElement), contentProvider.snippetContent());
    }

    private String extractContent(PythonParsedEntry codeEntry) {
        if (this.isBodyOnly) {
            return codeEntry.getBodyOnly();
        }
        return codeEntry.getContent();
    }
}

