/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import org.testingisdocumenting.znai.utils.FilePathUtils;
import org.testingisdocumenting.znai.utils.UrlUtils;

public class DocUrl {
    private static final String LINK_TO_SECTION_INSTRUCTION = "To refer to a section of a document page use either\n  dir-name/file-name-without-extension#page-section-id or\n  (#page-section-id is optional)\ndir-name is not an arbitrary directory name or structure, but the TOC directory associated with a chapter\nUse #page-section-id to refer to the current page section.\nUse /#section-id to refer the root page of a documentation.\n\nAlternatively you can use a relative path to another markdown file.\nPath can be relative to the root of the documentation or to the current file.\n";
    private String dirName = "";
    private String fileNameWithoutExtension = "";
    private String anchorId = "";
    private String tocItemFilePath = "";
    private String url;
    private boolean isExternalUrl;
    private boolean isAnchorOnly;
    private boolean isIndexUrl;

    public static DocUrl indexUrl() {
        return new DocUrl(true);
    }

    private DocUrl(boolean isIndexUrl) {
        this.isIndexUrl = isIndexUrl;
    }

    public DocUrl(String dirName, String fileNameWithoutExtension, String anchorId) {
        this.dirName = dirName;
        this.fileNameWithoutExtension = fileNameWithoutExtension;
        this.anchorId = anchorId;
    }

    public DocUrl(String url) {
        boolean handled;
        this.url = url;
        boolean bl = handled = this.handleExternal() || this.handleBasedOnFilePath(url) || this.handleLocalFile(url) || this.handleIndex() || this.handleAnchorOnly() || this.handleLocal();
        if (!handled) {
            throw new IllegalStateException("couldn't parse url: " + url);
        }
    }

    private boolean handleExternal() {
        this.isExternalUrl = UrlUtils.isExternal(this.url);
        return this.isExternalUrl;
    }

    private boolean handleLocalFile(String url) {
        return !FilePathUtils.fileExtension(url).isEmpty();
    }

    private boolean handleBasedOnFilePath(String url) {
        String withoutAnchor = UrlUtils.removeAnchor(url);
        String extension = FilePathUtils.fileExtension(withoutAnchor);
        if (extension.startsWith("md")) {
            this.tocItemFilePath = withoutAnchor;
            this.anchorId = UrlUtils.extractAnchor(url);
            return true;
        }
        return false;
    }

    private boolean handleIndex() {
        if (this.url.startsWith("/#")) {
            this.isIndexUrl = true;
            this.anchorId = this.url.substring(2);
            return true;
        }
        this.isIndexUrl = this.url.equals("/");
        return this.isIndexUrl;
    }

    private boolean handleAnchorOnly() {
        this.isAnchorOnly = this.url.startsWith("#");
        if (this.isAnchorOnly) {
            this.dirName = "";
            this.fileNameWithoutExtension = "";
            this.anchorId = this.url.substring(1);
        }
        return this.isAnchorOnly;
    }

    private boolean handleLocal() {
        String[] parts = this.url.split("/");
        if (parts.length != 2 && parts.length != 3) {
            throw new IllegalArgumentException("Unexpected url pattern: <" + this.url + "> To refer to a section of a document page use either\n  dir-name/file-name-without-extension#page-section-id or\n  (#page-section-id is optional)\ndir-name is not an arbitrary directory name or structure, but the TOC directory associated with a chapter\nUse #page-section-id to refer to the current page section.\nUse /#section-id to refer the root page of a documentation.\n\nAlternatively you can use a relative path to another markdown file.\nPath can be relative to the root of the documentation or to the current file.\n");
        }
        if (parts.length == 3 && !parts[0].equals("..")) {
            throw new IllegalArgumentException("Unexpected url pattern: <" + this.url + "> To refer to a section of a document page use either\n  dir-name/file-name-without-extension#page-section-id or\n  (#page-section-id is optional)\ndir-name is not an arbitrary directory name or structure, but the TOC directory associated with a chapter\nUse #page-section-id to refer to the current page section.\nUse /#section-id to refer the root page of a documentation.\n\nAlternatively you can use a relative path to another markdown file.\nPath can be relative to the root of the documentation or to the current file.\n");
        }
        int dirIdx = parts.length == 3 ? 1 : 0;
        int nameIdx = parts.length == 3 ? 2 : 1;
        this.dirName = parts[dirIdx];
        int idxOfAnchorSep = parts[nameIdx].indexOf(35);
        this.fileNameWithoutExtension = FilePathUtils.fileNameWithoutExtension(idxOfAnchorSep == -1 ? parts[nameIdx] : parts[nameIdx].substring(0, idxOfAnchorSep));
        this.anchorId = idxOfAnchorSep == -1 ? "" : parts[nameIdx].substring(idxOfAnchorSep + 1);
        return true;
    }

    public boolean isIndexUrl() {
        return this.isIndexUrl;
    }

    public boolean isExternalUrl() {
        return this.isExternalUrl;
    }

    public boolean isAnchorOnly() {
        return this.isAnchorOnly;
    }

    public boolean isFilePathBased() {
        return !this.tocItemFilePath.isEmpty();
    }

    public String getTocItemFilePath() {
        return this.tocItemFilePath;
    }

    public void setResolvedToDirNameAndFileName(String dirName, String fileNameWithoutExtension) {
        this.tocItemFilePath = "";
        this.dirName = dirName;
        this.fileNameWithoutExtension = fileNameWithoutExtension;
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getFileNameWithoutExtension() {
        return this.fileNameWithoutExtension;
    }

    public String getAnchorId() {
        return this.anchorId;
    }

    public String getAnchorIdWithHash() {
        return this.anchorId.isEmpty() ? "" : "#" + this.anchorId;
    }

    public String getUrl() {
        return this.url;
    }
}

