/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.website;

import java.nio.file.Path;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.ResourceUtils;

public class WebResource {
    private final Path originPath;
    private final String path;
    private final byte[] resourceContent;
    private final boolean isModule;

    private WebResource(Path originPath, String path, boolean isModule) {
        this.originPath = originPath;
        this.path = path;
        this.resourceContent = null;
        this.isModule = isModule;
    }

    private WebResource(Path originPath, String path) {
        this(originPath, path, false);
    }

    private WebResource(String resourcePath, boolean isModule) {
        this.originPath = null;
        this.path = resourcePath;
        this.resourceContent = ResourceUtils.binaryContent(resourcePath);
        this.isModule = isModule;
    }

    private WebResource(String resourcePath) {
        this(resourcePath, false);
    }

    private WebResource(String path, byte[] content) {
        this.originPath = null;
        this.path = path;
        this.resourceContent = content;
        this.isModule = false;
    }

    public static WebResource withPath(String path) {
        return new WebResource(null, path);
    }

    public static WebResource moduleWithPath(String path) {
        return new WebResource(null, path, true);
    }

    public static WebResource withPath(Path originPath, String webPath) {
        return new WebResource(originPath, webPath);
    }

    public static WebResource fromResource(String resourcePath) {
        return new WebResource(resourcePath);
    }

    public static WebResource moduleFromResource(String resourcePath) {
        return new WebResource(resourcePath, true);
    }

    public static WebResource withTextContent(String path, String content) {
        return new WebResource(path, content.getBytes());
    }

    public Path getOriginPath() {
        return this.originPath;
    }

    public String getPath() {
        return this.path;
    }

    public String generateCssLink(String documentationId) {
        return "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.pathForHtml(documentationId) + "\">";
    }

    public String generateJavaScriptLink(String documentationId) {
        String type = this.isModule ? "module" : "text/javascript";
        return "<script type=\"" + type + "\" src=\"" + this.pathForHtml(documentationId) + "\"></script>";
    }

    private String pathForHtml(String documentationId) {
        return "/" + (String)(documentationId.isEmpty() ? "" : documentationId + "/") + this.path;
    }

    public byte[] getBinaryContent() {
        return this.resourceContent == null ? FileUtils.fileBinaryContent(this.originPath) : this.resourceContent;
    }

    public String getTextContent() {
        return new String(this.getBinaryContent());
    }

    public String toString() {
        return (this.resourceContent == null ? "FromDisk" : "FromResource") + "{originPath=" + String.valueOf(this.originPath) + ", path='" + this.path + "'}";
    }
}

