/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.format.common;

import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.format.AbstractFormatAttribute;
import znaishaded.com.github.fge.jsonschema.format.FormatAttribute;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.google.common.net.InetAddresses;

public final class IPv6Attribute
extends AbstractFormatAttribute {
    private static final int IPV6_LENGTH = 16;
    private static final FormatAttribute INSTANCE = new IPv6Attribute();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private IPv6Attribute() {
        super("ipv6", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        String ipaddr = instance.textValue();
        if (InetAddresses.isInetAddress(ipaddr) && InetAddresses.forString(ipaddr).getAddress().length == 16) {
            return;
        }
        report.error(this.newMsg(data, bundle, "err.format.invalidIPV6Address").putArgument("value", ipaddr));
    }
}

