/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.processors.validation;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.node.ArrayNode;
import znaishaded.com.github.fge.jackson.JacksonUtils;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.core.exceptions.InvalidSchemaException;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.JsonTree;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.jsonschema.processors.data.SchemaContext;
import znaishaded.com.github.fge.jsonschema.processors.data.ValidatorList;
import znaishaded.com.github.fge.jsonschema.processors.validation.ArraySchemaDigester;
import znaishaded.com.github.fge.jsonschema.processors.validation.ArraySchemaSelector;
import znaishaded.com.github.fge.jsonschema.processors.validation.ObjectSchemaDigester;
import znaishaded.com.github.fge.jsonschema.processors.validation.ObjectSchemaSelector;
import znaishaded.com.github.fge.jsonschema.processors.validation.ValidationStack;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@NotThreadSafe
final class InstanceValidator
implements Processor<FullData, FullData> {
    private final MessageBundle syntaxMessages;
    private final MessageBundle validationMessages;
    private final Processor<SchemaContext, ValidatorList> keywordBuilder;
    private final ValidationStack stack;

    InstanceValidator(MessageBundle syntaxMessages, MessageBundle validationMessages, Processor<SchemaContext, ValidatorList> keywordBuilder) {
        this.syntaxMessages = syntaxMessages;
        this.validationMessages = validationMessages;
        this.keywordBuilder = keywordBuilder;
        String errmsg = validationMessages.getMessage("err.common.validationLoop");
        this.stack = new ValidationStack(errmsg);
    }

    @Override
    public FullData process(ProcessingReport report, FullData input) throws ProcessingException {
        this.stack.push(input);
        SchemaContext context = new SchemaContext(input);
        ValidatorList fullContext = this.keywordBuilder.process(report, context);
        if (fullContext == null) {
            ProcessingMessage message = this.collectSyntaxErrors(report);
            throw new InvalidSchemaException(message);
        }
        SchemaContext newContext = fullContext.getContext();
        FullData data = new FullData(newContext.getSchema(), input.getInstance(), input.isDeepCheck());
        for (KeywordValidator validator : fullContext) {
            validator.validate(this, report, this.validationMessages, data);
        }
        if (!report.isSuccess() && !data.isDeepCheck()) {
            this.stack.pop();
            return input;
        }
        JsonNode node = data.getInstance().getNode();
        if (node.isContainerNode()) {
            if (node.isArray()) {
                this.processArray(report, data);
            } else {
                this.processObject(report, data);
            }
        }
        this.stack.pop();
        return input;
    }

    public String toString() {
        return "instance validator";
    }

    private void processArray(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ArraySchemaDigester.getInstance().digest(schema);
        ArraySchemaSelector selector = new ArraySchemaSelector(digest);
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            JsonTree newInstance = instance.append(JsonPointer.of(index, new Object[0]));
            FullData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(index)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private void processObject(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ObjectSchemaDigester.getInstance().digest(schema);
        ObjectSchemaSelector selector = new ObjectSchemaSelector(digest);
        ArrayList<String> fields = Lists.newArrayList(node.fieldNames());
        Collections.sort(fields);
        for (String field : fields) {
            JsonTree newInstance = instance.append(JsonPointer.of(field, new Object[0]));
            FullData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(field)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private ProcessingMessage collectSyntaxErrors(ProcessingReport report) {
        String msg = this.syntaxMessages.getMessage("core.invalidSchema");
        ArrayNode arrayNode = JacksonUtils.nodeFactory().arrayNode();
        for (ProcessingMessage message : report) {
            JsonNode node = message.asJson();
            if (!"syntax".equals(node.path("domain").asText())) continue;
            arrayNode.add(node);
        }
        StringBuilder sb = new StringBuilder(msg);
        sb.append("\nSyntax errors:\n");
        sb.append(JacksonUtils.prettyPrint(arrayNode));
        return new ProcessingMessage().setMessage(sb.toString());
    }
}

