/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.models.properties;

import znaishaded.com.fasterxml.jackson.annotation.JsonIgnore;
import znaishaded.io.swagger.models.properties.AbstractProperty;
import znaishaded.io.swagger.models.properties.Property;
import znaishaded.io.swagger.models.refs.GenericRef;
import znaishaded.io.swagger.models.refs.RefFormat;
import znaishaded.io.swagger.models.refs.RefType;

public class RefProperty
extends AbstractProperty
implements Property {
    public static final String TYPE = "ref";
    private GenericRef genericRef;

    public RefProperty() {
        this.setType(TYPE);
    }

    public RefProperty(String ref) {
        this(ref, null);
    }

    public RefProperty(String ref, RefFormat refFormat) {
        this();
        this.genericRef = new GenericRef(RefType.DEFINITION, ref, refFormat);
    }

    public static boolean isType(String type, String format) {
        return TYPE.equals(type);
    }

    public RefProperty asDefault(String ref) {
        this.set$ref(RefType.DEFINITION.getInternalPrefix() + ref);
        return this;
    }

    @Override
    public RefProperty description(String description) {
        this.setDescription(description);
        return this;
    }

    @Override
    @JsonIgnore
    public String getType() {
        return this.type;
    }

    @Override
    @JsonIgnore
    public void setType(String type) {
        this.type = type;
    }

    public String get$ref() {
        return this.genericRef.getRef();
    }

    public void set$ref(String ref) {
        this.genericRef = new GenericRef(RefType.DEFINITION, ref);
    }

    @JsonIgnore
    public RefFormat getRefFormat() {
        if (this.genericRef != null) {
            return this.genericRef.getFormat();
        }
        return null;
    }

    @JsonIgnore
    public String getSimpleRef() {
        if (this.genericRef != null) {
            return this.genericRef.getSimpleRef();
        }
        return null;
    }

    public String getOriginalRef() {
        if (this.genericRef != null) {
            return this.genericRef.getOriginalRef();
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.genericRef == null ? 0 : this.genericRef.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RefProperty)) {
            return false;
        }
        RefProperty other = (RefProperty)obj;
        return !(this.genericRef == null ? other.genericRef != null : !this.genericRef.equals(other.genericRef));
    }
}

