/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.transform.migrate.resourcelisting;

import javax.annotation.Nonnull;
import javax.annotation.Untainted;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.node.ObjectNode;
import znaishaded.com.google.common.base.Preconditions;
import znaishaded.io.swagger.transform.migrate.SwaggerMigrator;
import znaishaded.io.swagger.transform.util.SwaggerMigrationException;

public final class PathAppenderMigrator
implements SwaggerMigrator {
    private final String basePath;

    public PathAppenderMigrator(@Untainted @Nonnull String basePath) {
        this.basePath = basePath;
    }

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        try {
            Preconditions.checkArgument(input.isObject(), "expected JSON to be a JSON object but it isn't");
            Preconditions.checkArgument(input.path("path").isTextual(), "\"path\" member of API object is not a JSON string");
        }
        catch (IllegalArgumentException e) {
            throw new SwaggerMigrationException(e.getMessage());
        }
        ObjectNode node = (ObjectNode)input.deepCopy();
        String oldPath = node.get("path").textValue();
        node.put("path", this.basePath + oldPath);
        return node;
    }
}

