/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.parser.reference;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.org.apache.commons.lang3.StringUtils;

public class ReferenceUtils {
    public static String toBaseURI(String uri) throws Exception {
        URI resolved = new URI(uri);
        return (resolved.getScheme() != null ? resolved.getScheme() + ":" : "") + resolved.getSchemeSpecificPart();
    }

    public static String getFragment(String uri) throws Exception {
        URI resolved = new URI(uri);
        return resolved.getFragment();
    }

    public static String resolve(String uri, String baseURI) throws Exception {
        if (StringUtils.isBlank(uri)) {
            return baseURI;
        }
        return new URI(baseURI).resolve(uri).toString();
    }

    public static boolean isLocalRef(String ref) {
        return !StringUtils.isBlank(ref) && ref.startsWith("#");
    }

    public static boolean isLocalRefToComponents(String ref) {
        return !StringUtils.isBlank(ref) && ref.startsWith("#/components");
    }

    public static boolean isAnchorRef(String ref) {
        if (!StringUtils.isBlank(ref) && ref.startsWith("#")) {
            return ReferenceUtils.isAnchor(ref.substring(1));
        }
        return false;
    }

    public static boolean isAnchor(String ref) {
        return !StringUtils.isBlank(ref) && Pattern.matches("^[A-Za-z_][A-Za-z_0-9.-]*$", ref);
    }

    public static String unescapePointer(String jsonPathElement) {
        try {
            jsonPathElement = URLDecoder.decode(jsonPathElement, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        jsonPathElement = jsonPathElement.replaceAll("~1", "/");
        return jsonPathElement.replaceAll("~0", "~");
    }

    public static JsonNode jsonPointerEvaluate(String fragment, JsonNode tree, String uri) {
        if (StringUtils.isBlank(fragment)) {
            return tree;
        }
        String[] tokens = fragment.split("/");
        JsonNode node = tree;
        for (String token : tokens) {
            if (StringUtils.isBlank(token) || (node = node.isArray() ? node.get(Integer.valueOf(token)) : node.get(ReferenceUtils.unescapePointer(token))) != null) continue;
            throw new RuntimeException("Could not find " + fragment + " in contents of " + uri);
        }
        return node;
    }

    public static String getRefName(String uri) {
        if (uri.indexOf("/") == -1 && uri.startsWith("#")) {
            return uri.substring(1);
        }
        String[] tokens = uri.split("/");
        return tokens[tokens.length - 1];
    }
}

