/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.argon2.model;

import java.util.Arrays;
import znaishaded.net.sourceforge.plantuml.argon2.Util;

public class Block {
    public long[] v = new long[128];

    public void fromBytes(byte[] input) {
        assert (input.length == 1024);
        for (int i = 0; i < this.v.length; ++i) {
            byte[] slice = Arrays.copyOfRange(input, i * 8, (i + 1) * 8);
            this.v[i] = Util.littleEndianBytesToLong(slice);
        }
    }

    public byte[] toBytes() {
        byte[] result = new byte[1024];
        for (int i = 0; i < this.v.length; ++i) {
            byte[] bytes = Util.longToLittleEndianBytes(this.v[i]);
            System.arraycopy(bytes, 0, result, i * bytes.length, bytes.length);
        }
        return result;
    }

    public void copyBlock(Block other) {
        System.arraycopy(other.v, 0, this.v, 0, this.v.length);
    }

    public void xor(Block b1, Block b2) {
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = b1.v[i] ^ b2.v[i];
        }
    }

    public void xor(Block b1, Block b2, Block b3) {
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = b1.v[i] ^ b2.v[i] ^ b3.v[i];
        }
    }

    public void xorWith(Block other) {
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = this.v[i] ^ other.v[i];
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (long value : this.v) {
            result.append(Util.bytesToHexString(Util.longToLittleEndianBytes(value)));
        }
        return result.toString();
    }

    void clear() {
        Arrays.fill(this.v, 0L);
    }
}

