/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.atmp.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.EmbeddedDiagram;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Elected;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.AbstractPlacementStrategy;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.PlacementStrategyVisibility;
import znaishaded.net.sourceforge.plantuml.klimt.geom.PlacementStrategyY1Y2Center;
import znaishaded.net.sourceforge.plantuml.klimt.geom.PlacementStrategyY1Y2Left;
import znaishaded.net.sourceforge.plantuml.klimt.geom.PlacementStrategyY1Y2Right;
import znaishaded.net.sourceforge.plantuml.klimt.geom.ULayoutGroup;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockLineBefore;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockWithUrl;
import znaishaded.net.sourceforge.plantuml.skin.VisibilityModifier;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.svek.Ports;
import znaishaded.net.sourceforge.plantuml.svek.WithPorts;
import znaishaded.net.sourceforge.plantuml.url.Url;
import znaishaded.net.sourceforge.plantuml.utils.CharHidder;

public class MethodsOrFieldsArea
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final ISkinParam skinParam;
    private final Display members;
    private final HorizontalAlignment align;
    private final List<EmbeddedDiagram> embeddeds = new ArrayList<EmbeddedDiagram>();
    private final Entity leaf;
    private final Style style;

    public TextBlock asBlockMemberImpl() {
        return new TextBlockLineBefore(this.style.value(PName.LineThickness).asDouble(), TextBlockUtils.withMargin(this, 6.0, 4.0));
    }

    public MethodsOrFieldsArea(Display members, ISkinParam skinParam, Entity leaf, Style style) {
        this(members, skinParam, HorizontalAlignment.LEFT, leaf, style);
    }

    public MethodsOrFieldsArea(Display members, ISkinParam skinParam, HorizontalAlignment align, Entity leaf, Style style) {
        this.style = style;
        this.leaf = leaf;
        this.align = align;
        this.skinParam = skinParam;
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        Iterator it = members.iterator();
        while (it.hasNext()) {
            CharSequence cs = (CharSequence)it.next();
            String type = EmbeddedDiagram.getEmbeddedType(StringUtils.trinNoTrace(cs));
            if (type != null) {
                this.embeddeds.add(EmbeddedDiagram.createAndSkip(type, it, skinParam));
                continue;
            }
            result.add(cs);
        }
        this.members = Display.create(result);
    }

    private boolean hasSmallIcon() {
        if (this.skinParam.classAttributeIconSize() == 0) {
            return false;
        }
        for (CharSequence cs : this.members) {
            Member m3;
            if (!(cs instanceof Member) || (m3 = (Member)cs).getVisibilityModifier() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim1 = this.calculateDimensionOnlyMembers(stringBounder);
        double x = dim1.getWidth();
        double y = dim1.getHeight();
        for (EmbeddedDiagram embedded : this.embeddeds) {
            XDimension2D dim = embedded.calculateDimension(stringBounder);
            x = Math.max(dim.getWidth(), x);
            y += dim.getHeight();
        }
        return new XDimension2D(x, y);
    }

    private XDimension2D calculateDimensionOnlyMembers(StringBounder stringBounder) {
        double smallIcon = 0.0;
        if (this.hasSmallIcon()) {
            smallIcon = this.skinParam.getCircledCharacterRadius() + 3;
        }
        double x = 0.0;
        double y = 0.0;
        for (CharSequence cs : this.members) {
            TextBlock bloc = this.createTextBlock(cs);
            XDimension2D dim = bloc.calculateDimension(stringBounder);
            x = Math.max(dim.getWidth(), x);
            y += dim.getHeight();
        }
        return new XDimension2D(x += smallIcon, y);
    }

    private Collection<String> sortBySize(Collection<String> all) {
        ArrayList<String> result = new ArrayList<String>(all);
        Collections.sort(result, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int diff = s2.length() - s1.length();
                if (diff != 0) {
                    return diff;
                }
                return s1.compareTo(s2);
            }
        });
        return result;
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        Ports ports = new Ports();
        double y = 0.0;
        Collection<String> shortNames = this.sortBySize(this.leaf.getPortShortNames());
        for (CharSequence cs : this.members) {
            TextBlock bloc = this.createTextBlock(cs);
            XDimension2D dim = bloc.calculateDimension(stringBounder);
            Elected elected = this.getElected(this.convert(cs), shortNames);
            if (elected != null) {
                ports.add(elected.getShortName(), elected.getScore(), y, dim.getHeight());
            }
            y += dim.getHeight();
        }
        return ports;
    }

    private String convert(CharSequence cs) {
        if (cs instanceof Member) {
            return ((Member)cs).getDisplay(false);
        }
        return cs.toString();
    }

    public Elected getElected(String cs, Collection<String> shortNames) {
        for (String shortName : shortNames) {
            int score = this.getScore(cs, shortName);
            if (score <= 0) continue;
            return new Elected(shortName, score);
        }
        return null;
    }

    private int getScore(String cs, String shortName) {
        if (cs.matches(".*\\b" + shortName + "\\b.*")) {
            return 100;
        }
        if (cs.contains(shortName)) {
            return 50;
        }
        return 0;
    }

    private TextBlock createTextBlock(CharSequence cs) {
        FontConfiguration config = FontConfiguration.create(this.skinParam, this.style, this.leaf.getColors());
        if (cs instanceof Member) {
            Member m3 = (Member)cs;
            boolean withVisibilityChar = this.skinParam.classAttributeIconSize() == 0;
            String s2 = m3.getDisplay(withVisibilityChar);
            if (withVisibilityChar && s2.startsWith("#")) {
                s2 = CharHidder.addTileAtBegin(s2);
            }
            if (m3.isAbstract()) {
                config = config.italic();
            }
            if (m3.isStatic()) {
                config = config.underline();
            }
            TextBlock bloc = Display.getWithNewlines(s2).create8(config, this.align, this.skinParam, CreoleMode.SIMPLE_LINE, this.style.wrapWidth());
            bloc = TextBlockUtils.fullInnerPosition(bloc, m3.getDisplay(false));
            return new TextBlockTracer(m3, bloc);
        }
        return Display.getWithNewlines(cs.toString()).create8(config, this.align, this.skinParam, CreoleMode.SIMPLE_LINE, this.style.wrapWidth());
    }

    private TextBlock getUBlock(VisibilityModifier modifier, Url url) {
        if (modifier == null) {
            return new AbstractTextBlock(){

                @Override
                public void drawU(UGraphic ug) {
                }

                @Override
                public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                    return null;
                }

                @Override
                public XDimension2D calculateDimension(StringBounder stringBounder) {
                    return new XDimension2D(1.0, 1.0);
                }
            };
        }
        Style style = modifier.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        HColor borderColor = style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        boolean isField = modifier.isField();
        HColor backColor = isField ? null : style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        TextBlock uBlock = modifier.getUBlock(this.skinParam.classAttributeIconSize(), borderColor, backColor, url != null);
        return TextBlockWithUrl.withUrl(uBlock, url);
    }

    public boolean contains(String member) {
        for (CharSequence cs : this.members) {
            Member att = (Member)cs;
            if (!att.getDisplay(false).startsWith(member)) continue;
            return true;
        }
        return false;
    }

    @Override
    public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        ULayoutGroup group = this.getLayout(stringBounder);
        XDimension2D dim = this.calculateDimension(stringBounder);
        return group.getInnerPosition(member, dim.getWidth(), dim.getHeight(), stringBounder);
    }

    private ULayoutGroup getLayout(StringBounder stringBounder) {
        ULayoutGroup group;
        if (this.hasSmallIcon()) {
            group = new ULayoutGroup(new PlacementStrategyVisibility(stringBounder, this.skinParam.getCircledCharacterRadius() + 3));
            for (CharSequence cs : this.members) {
                TextBlock bloc = this.createTextBlock(cs);
                Member att = (Member)cs;
                VisibilityModifier modifier = att.getVisibilityModifier();
                group.add(this.getUBlock(modifier, att.getUrl()));
                group.add(bloc);
            }
        } else {
            AbstractPlacementStrategy placementStrategy = this.align == HorizontalAlignment.LEFT ? new PlacementStrategyY1Y2Left(stringBounder) : (this.align == HorizontalAlignment.CENTER ? new PlacementStrategyY1Y2Center(stringBounder) : new PlacementStrategyY1Y2Right(stringBounder));
            group = new ULayoutGroup(placementStrategy);
            for (CharSequence cs : this.members) {
                TextBlock bloc = this.createTextBlock(cs);
                group.add(bloc);
            }
        }
        return group;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ULayoutGroup group = this.getLayout(stringBounder);
        XDimension2D dim = this.calculateDimensionOnlyMembers(stringBounder);
        group.drawU(ug, dim.getWidth(), dim.getHeight());
        ug = ug.apply(UTranslate.dy(dim.getHeight()));
        for (EmbeddedDiagram embedded : this.embeddeds) {
            embedded.drawU(ug);
            ug = ug.apply(UTranslate.dy(embedded.calculateDimension(stringBounder).getHeight()));
        }
    }

    static class TextBlockTracer
    extends AbstractTextBlock
    implements TextBlock {
        private final TextBlock bloc;
        private final Url url;

        public TextBlockTracer(Member m3, TextBlock bloc) {
            this.bloc = bloc;
            this.url = m3.getUrl();
        }

        @Override
        public void drawU(UGraphic ug) {
            if (this.url != null) {
                ug.startUrl(this.url);
            }
            this.bloc.drawU(ug);
            if (this.url != null) {
                ug.closeUrl();
            }
        }

        @Override
        public XDimension2D calculateDimension(StringBounder stringBounder) {
            XDimension2D dim = this.bloc.calculateDimension(stringBounder);
            return dim;
        }

        @Override
        public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
            return this.bloc.getInnerPosition(member, stringBounder, strategy);
        }
    }
}

