/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram.command;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.abel.LinkArrow;
import znaishaded.net.sourceforge.plantuml.descdiagram.command.StringWithArrow;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;

public class Labels {
    private String firstLabel;
    private String secondLabel;
    private final StringWithArrow stringWithArrow;

    public Labels(RegexResult arg) {
        this.firstLabel = arg.get("FIRST_LABEL", 0);
        this.secondLabel = arg.get("SECOND_LABEL", 0);
        String labelLink = arg.get("LABEL_LINK", 0);
        if (labelLink != null) {
            labelLink = this.init(labelLink);
        }
        this.stringWithArrow = new StringWithArrow(labelLink);
    }

    private String init(String labelLink) {
        if (this.firstLabel == null && this.secondLabel == null) {
            Pattern2 p1 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)[%g]([^%g]+)[%g]$");
            Matcher2 m1 = p1.matcher(labelLink);
            if (m1.matches()) {
                this.firstLabel = m1.group(1);
                this.secondLabel = m1.group(3);
                return StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m1.group(2))));
            }
            Pattern2 p2 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)$");
            Matcher2 m22 = p2.matcher(labelLink);
            if (m22.matches()) {
                this.firstLabel = m22.group(1);
                this.secondLabel = null;
                return StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m22.group(2))));
            }
            Pattern2 p3 = MyPattern.cmpile("^([^%g]+)[%g]([^%g]+)[%g]$");
            Matcher2 m3 = p3.matcher(labelLink);
            if (m3.matches()) {
                this.firstLabel = null;
                this.secondLabel = m3.group(2);
                return StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m3.group(1))));
            }
        }
        return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(labelLink, "\"");
    }

    public final String getFirstLabel() {
        return this.firstLabel;
    }

    public final String getSecondLabel() {
        return this.secondLabel;
    }

    public final String getLabelLink() {
        return this.stringWithArrow.getLabel();
    }

    public final LinkArrow getLinkArrow() {
        return this.stringWithArrow.getLinkArrow();
    }

    public Display getDisplay() {
        return this.stringWithArrow.getDisplay();
    }
}

