/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.dot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.EntityFactory;
import znaishaded.net.sourceforge.plantuml.abel.EntityPortion;
import znaishaded.net.sourceforge.plantuml.abel.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.dot.Neighborhood;
import znaishaded.net.sourceforge.plantuml.skin.Pragma;
import znaishaded.net.sourceforge.plantuml.skin.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.svek.DotMode;

public final class DotData
implements PortionShower {
    private final List<Link> links;
    private final Collection<Entity> leafs;
    private final UmlDiagramType umlDiagramType;
    private final ISkinParam skinParam;
    private final GroupHierarchy groupHierarchy;
    private final Entity topParent;
    private final PortionShower portionShower;
    private final boolean isHideEmptyDescriptionForState;
    private final DotMode dotMode;
    private final String namespaceSeparator;
    private final Pragma pragma;
    private final EntityFactory entityFactory;

    public EntityFactory getEntityFactory() {
        return this.entityFactory;
    }

    public DotData(Entity topParent, List<Link> links, Collection<Entity> leafs, UmlDiagramType umlDiagramType, ISkinParam skinParam, GroupHierarchy groupHierarchy, PortionShower portionShower, EntityFactory entityFactory, boolean isHideEmptyDescriptionForState, DotMode dotMode, String namespaceSeparator, Pragma pragma) {
        this.namespaceSeparator = namespaceSeparator;
        this.pragma = pragma;
        this.topParent = Objects.requireNonNull(topParent);
        this.dotMode = dotMode;
        this.isHideEmptyDescriptionForState = isHideEmptyDescriptionForState;
        this.links = links;
        this.leafs = leafs;
        this.umlDiagramType = umlDiagramType;
        this.skinParam = skinParam;
        this.groupHierarchy = groupHierarchy;
        this.portionShower = portionShower;
        this.entityFactory = entityFactory;
    }

    public DotData(Entity topParent, List<Link> links, Collection<Entity> leafs, UmlDiagramType umlDiagramType, ISkinParam skinParam, GroupHierarchy groupHierarchy, EntityFactory entityFactory, boolean isHideEmptyDescriptionForState, DotMode dotMode, String namespaceSeparator, Pragma pragma) {
        this(topParent, links, leafs, umlDiagramType, skinParam, groupHierarchy, new PortionShower(){

            @Override
            public boolean showPortion(EntityPortion portion, Entity entity) {
                return true;
            }
        }, entityFactory, isHideEmptyDescriptionForState, dotMode, namespaceSeparator, pragma);
    }

    public UmlDiagramType getUmlDiagramType() {
        return this.umlDiagramType;
    }

    public ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public GroupHierarchy getGroupHierarchy() {
        return this.groupHierarchy;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public Collection<Entity> getLeafs() {
        return this.leafs;
    }

    public final Entity getTopParent() {
        return this.topParent;
    }

    public boolean isEmpty(Entity g2) {
        return this.groupHierarchy.isEmpty(g2);
    }

    @Override
    public boolean showPortion(EntityPortion portion, Entity entity) {
        return this.portionShower.showPortion(portion, entity);
    }

    public Entity getRootGroup() {
        return this.entityFactory.getRootGroup();
    }

    public boolean isDegeneratedWithFewEntities(int nb) {
        return this.entityFactory.groups().size() == 0 && this.getLinks().size() == 0 && this.getLeafs().size() == nb;
    }

    public final boolean isHideEmptyDescriptionForState() {
        return this.isHideEmptyDescriptionForState;
    }

    public final DotMode getDotMode() {
        return this.dotMode;
    }

    public final String getNamespaceSeparator() {
        return this.namespaceSeparator;
    }

    public Pragma getPragma() {
        return this.pragma;
    }

    public void removeIrrelevantSametail() {
        HashMap<String, Integer> sametails = new HashMap<String, Integer>();
        for (Link link : this.links) {
            String sametail;
            if (link.getType().getDecor2().isExtendsLike()) {
                link.setSametail(link.getEntity1().getUid());
            }
            if ((sametail = link.getSametail()) == null) continue;
            Integer value = (Integer)sametails.get(sametail);
            sametails.put(sametail, value == null ? 1 : value + 1);
        }
        HashSet<String> toremove = new HashSet<String>();
        int limit = this.skinParam.groupInheritance();
        for (Map.Entry ent : sametails.entrySet()) {
            String key = (String)ent.getKey();
            if ((Integer)ent.getValue() < limit) {
                toremove.add(key);
                continue;
            }
            ArrayList<Link> some = new ArrayList<Link>();
            for (Link link : this.links) {
                if (!key.equals(link.getSametail())) continue;
                some.add(link);
            }
            Entity leaf = this.getLeaf(key);
            Neighborhood neighborhood = new Neighborhood(leaf, some, this.getLinksOfThisLeaf(leaf));
            leaf.setNeighborhood(neighborhood);
        }
        for (Link link : this.links) {
            String sametail = link.getSametail();
            if (sametail == null || !toremove.contains(sametail)) continue;
            link.setSametail(null);
        }
    }

    private List<Link> getLinksOfThisLeaf(Entity leaf) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.contains(leaf)) continue;
            result.add(link);
        }
        return result;
    }

    private Entity getLeaf(String key) {
        for (Entity entity : this.leafs) {
            if (!entity.getUid().equals(key)) continue;
            return entity;
        }
        return null;
    }
}

