/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.creole.atom;

import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.AbstractAtom;
import znaishaded.net.sourceforge.plantuml.klimt.creole.atom.Atom;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.openiconic.OpenIcon;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class AtomOpenIcon
extends AbstractAtom
implements Atom {
    private final OpenIcon openIcon;
    private final double factor;
    private final Url url;
    private final HColor color;

    public AtomOpenIcon(HColor newColor, double scale, OpenIcon openIcon, FontConfiguration fontConfiguration, Url url) {
        this.url = url;
        this.openIcon = openIcon;
        this.factor = scale * fontConfiguration.getSize2D() / 12.0;
        this.color = newColor == null ? fontConfiguration.getColor() : newColor;
    }

    private TextBlock asTextBlock() {
        return TextBlockUtils.withMargin(this.openIcon.asTextBlock(this.color, this.factor), 1.0, 0.0);
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.asTextBlock().calculateDimension(stringBounder);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return -3.0 * this.factor;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.asTextBlock().drawU(ug);
        if (this.url != null) {
            ug.closeUrl();
        }
    }
}

