/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.svg;

import java.awt.geom.Line2D;
import znaishaded.net.sourceforge.plantuml.klimt.ClipContainer;
import znaishaded.net.sourceforge.plantuml.klimt.UClip;
import znaishaded.net.sourceforge.plantuml.klimt.UParam;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColorGradient;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UDriver;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;

public class DriverLineSvg
implements UDriver<ULine, SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverLineSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(ULine shape, double x, double y, ColorMapper mapper, UParam param, SvgGraphics svg) {
        HColor color;
        double x2 = x + shape.getDX();
        double y2 = y + shape.getDY();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Line2D.Double line = clip.getClippedLine(new Line2D.Double(x, y, x2, y2));
            if (line == null) {
                return;
            }
            x = line.x1;
            y = line.y1;
            x2 = line.x2;
            y2 = line.y2;
        }
        if ((color = param.getColor()) instanceof HColorGradient) {
            HColorGradient gr = (HColorGradient)color;
            svg.setStrokeColor(gr.getColor1().toSvg(mapper));
        } else {
            svg.setStrokeColor(color.toSvg(mapper));
        }
        svg.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDasharraySvg());
        svg.svgLine(x, y, x2, y2, shape.getDeltaShadow());
    }
}

