/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.drawing.visio;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.visio.VisioShape;

public class VisioLine
implements VisioShape {
    private final int id;
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;

    public static VisioLine createInches(int id, double x1, double y1, double x2, double y2) {
        return new VisioLine(id, VisioLine.toInches(x1), VisioLine.toInches(y1), VisioLine.toInches(x2), VisioLine.toInches(y2));
    }

    private VisioLine(int id, double x1, double y1, double x2, double y2) {
        if (x1 < 0.0 || y1 < 0.0 || x2 < 0.0 || y2 < 0.0) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public VisioShape yReverse(double maxY) {
        return new VisioLine(this.id, this.x1, maxY - this.y1, this.x2, maxY - this.y2);
    }

    private static double toInches(double val) {
        return val / 72.0;
    }

    @Override
    public void print(OutputStream os) throws IOException {
        this.out(os, "<Shape ID='" + this.id + "' Type='Shape' LineStyle='3' FillStyle='3' TextStyle='3'>");
        this.out(os, "<XForm>");
        double ddx = this.x2 - this.x1;
        double ddy = this.y2 - this.y1;
        this.out(os, "<PinX F='(BeginX+EndX)/2'>" + (this.x1 + this.x2) / 2.0 + "</PinX>");
        this.out(os, "<PinY F='(BeginY+EndY)/2'>" + (this.y1 + this.y2) / 2.0 + "</PinY>");
        double len = Math.sqrt(ddx * ddx + ddy * ddy);
        this.out(os, "<Width F='Sqrt((EndX-BeginX)^2+(EndY-BeginY)^2)'>" + len + "</Width>");
        this.out(os, "<Height>0</Height>");
        this.out(os, "<LocPinX F='Width*0.5'>" + len / 2.0 + "</LocPinX>");
        this.out(os, "<LocPinY F='Height*0.5'>0</LocPinY>");
        double atan2 = Math.atan2(ddy, ddx);
        this.out(os, "<Angle F='ATan2(EndY-BeginY,EndX-BeginX)'>" + atan2 + "</Angle>");
        this.out(os, "<FlipX>0</FlipX>");
        this.out(os, "<FlipY>0</FlipY>");
        this.out(os, "<ResizeMode>0</ResizeMode>");
        this.out(os, "</XForm>");
        this.out(os, "<XForm1D>");
        this.out(os, "<BeginX>" + this.x1 + "</BeginX>");
        this.out(os, "<BeginY>" + this.y1 + "</BeginY>");
        this.out(os, "<EndX>" + this.x2 + "</EndX>");
        this.out(os, "<EndY>" + this.y2 + "</EndY>");
        this.out(os, "</XForm1D>");
        this.out(os, "<Geom IX='0'>");
        this.out(os, "<NoFill>1</NoFill>");
        this.out(os, "<NoLine>0</NoLine>");
        this.out(os, "<NoShow>0</NoShow>");
        this.out(os, "<NoSnap>0</NoSnap>");
        this.out(os, "<MoveTo IX='1'>");
        this.out(os, "<X F='Width*0'>0</X>");
        this.out(os, "<Y>0</Y>");
        this.out(os, "</MoveTo>");
        this.out(os, "<LineTo IX='2'>");
        this.out(os, "<X F='Width*1'>" + len + "</X>");
        this.out(os, "<Y>0</Y>");
        this.out(os, "</LineTo>");
        this.out(os, "</Geom>");
        this.out(os, "</Shape>");
    }

    private void out(OutputStream os, String s2) throws IOException {
        os.write(s2.getBytes());
        os.write("\n".getBytes());
    }
}

