/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sdot;

import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XCubicCurve2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.DotPath;

public class YMirror {
    private final double max;

    public YMirror(double max) {
        this.max = max;
    }

    public double getMirrored(double v) {
        if (v < 0.0 || v > this.max) {
            System.err.println("BAD VALUE IN YMirror");
        }
        return this.max - v;
    }

    public XPoint2D getMirrored(XPoint2D pt) {
        return new XPoint2D(pt.getX(), this.max - pt.getY());
    }

    public DotPath getMirrored(DotPath path) {
        DotPath result = new DotPath();
        for (XCubicCurve2D bez : path.getBeziers()) {
            result = result.addCurve(this.getMirrored(bez.getP1()), this.getMirrored(bez.getCtrlP1()), this.getMirrored(bez.getCtrlP2()), this.getMirrored(bez.getP2()));
        }
        return result;
    }

    public UTranslate getMirrored(UTranslate tr) {
        return new UTranslate(tr.getDx(), this.max - tr.getDy());
    }
}

