/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.MinMax;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;

public class DecorateEntityImage
extends AbstractTextBlock {
    private final TextBlock original;
    private final HorizontalAlignment horizontal1;
    private final TextBlock text1;
    private final HorizontalAlignment horizontal2;
    private final TextBlock text2;
    private double deltaX;
    private double deltaY;

    public static TextBlock addTop(TextBlock original, TextBlock text, HorizontalAlignment horizontal) {
        return new DecorateEntityImage(original, text, horizontal, null, null);
    }

    public static TextBlock addBottom(TextBlock original, TextBlock text, HorizontalAlignment horizontal) {
        return new DecorateEntityImage(original, null, null, text, horizontal);
    }

    public static TextBlock add(TextBlock original, TextBlock text, HorizontalAlignment horizontal, VerticalAlignment verticalAlignment) {
        if (verticalAlignment == VerticalAlignment.TOP) {
            return DecorateEntityImage.addTop(original, text, horizontal);
        }
        return DecorateEntityImage.addBottom(original, text, horizontal);
    }

    public static TextBlock addTopAndBottom(TextBlock original, TextBlock text1, HorizontalAlignment horizontal1, TextBlock text2, HorizontalAlignment horizontal2) {
        return new DecorateEntityImage(original, text1, horizontal1, text2, horizontal2);
    }

    private DecorateEntityImage(TextBlock original, TextBlock text1, HorizontalAlignment horizontal1, TextBlock text2, HorizontalAlignment horizontal2) {
        this.original = Objects.requireNonNull(original);
        this.horizontal1 = horizontal1;
        this.text1 = text1;
        this.horizontal2 = horizontal2;
        this.text2 = text2;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimOriginal = this.original.calculateDimension(stringBounder);
        XDimension2D dimText1 = this.getTextDim(this.text1, stringBounder);
        XDimension2D dimText2 = this.getTextDim(this.text2, stringBounder);
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        double yImage = dimText1.getHeight();
        double yText2 = yImage + dimOriginal.getHeight();
        double xImage = (dimTotal.getWidth() - dimOriginal.getWidth()) / 2.0;
        if (this.text1 != null) {
            double xText1 = this.getTextX(dimText1, dimTotal, this.horizontal1);
            this.text1.drawU(ug.apply(UTranslate.dx(xText1)));
        }
        this.original.drawU(ug.apply(new UTranslate(xImage, yImage)));
        this.deltaX = xImage;
        this.deltaY = yImage;
        if (this.text2 != null) {
            double xText2 = this.getTextX(dimText2, dimTotal, this.horizontal2);
            this.text2.drawU(ug.apply(new UTranslate(xText2, yText2)));
        }
    }

    private XDimension2D getTextDim(TextBlock text, StringBounder stringBounder) {
        if (text == null) {
            return new XDimension2D(0.0, 0.0);
        }
        return text.calculateDimension(stringBounder);
    }

    private double getTextX(XDimension2D dimText, XDimension2D dimTotal, HorizontalAlignment h2) {
        if (h2 == HorizontalAlignment.CENTER) {
            return (dimTotal.getWidth() - dimText.getWidth()) / 2.0;
        }
        if (h2 == HorizontalAlignment.LEFT) {
            return 0.0;
        }
        if (h2 == HorizontalAlignment.RIGHT) {
            return dimTotal.getWidth() - dimText.getWidth();
        }
        throw new IllegalStateException();
    }

    @Override
    public HColor getBackcolor() {
        return this.original.getBackcolor();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dimOriginal = this.original.calculateDimension(stringBounder);
        XDimension2D dim1 = this.getTextDim(this.text1, stringBounder);
        XDimension2D dim2 = this.getTextDim(this.text2, stringBounder);
        XDimension2D dimText = dim1.mergeTB(dim2);
        return dimOriginal.mergeTB(dimText);
    }

    @Override
    public MinMax getMinMax(StringBounder stringBounder) {
        return MinMax.fromDim(this.calculateDimension(stringBounder));
    }

    public final double getDeltaX() {
        if (this.original instanceof DecorateEntityImage) {
            return this.deltaX + ((DecorateEntityImage)this.original).deltaX;
        }
        return this.deltaX;
    }

    public final double getDeltaY() {
        if (this.original instanceof DecorateEntityImage) {
            return this.deltaY + ((DecorateEntityImage)this.original).deltaY;
        }
        return this.deltaY;
    }
}

