/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.atmp.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.EntityFactory;
import znaishaded.net.sourceforge.plantuml.abel.EntityPosition;
import znaishaded.net.sourceforge.plantuml.abel.GroupType;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.abel.Link;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.decoration.symbol.USymbolHexagon;
import znaishaded.net.sourceforge.plantuml.descdiagram.EntityImageDesignedDomain;
import znaishaded.net.sourceforge.plantuml.descdiagram.EntityImageDomain;
import znaishaded.net.sourceforge.plantuml.descdiagram.EntityImageMachine;
import znaishaded.net.sourceforge.plantuml.descdiagram.EntityImageRequirement;
import znaishaded.net.sourceforge.plantuml.dot.DotData;
import znaishaded.net.sourceforge.plantuml.dot.ExeState;
import znaishaded.net.sourceforge.plantuml.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.dot.GraphvizVersion;
import znaishaded.net.sourceforge.plantuml.dot.Neighborhood;
import znaishaded.net.sourceforge.plantuml.dot.UnparsableGraphvizException;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.MagneticBorderNone;
import znaishaded.net.sourceforge.plantuml.klimt.geom.MinMax;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.GraphicStrings;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.security.SecurityProfile;
import znaishaded.net.sourceforge.plantuml.security.SecurityUtils;
import znaishaded.net.sourceforge.plantuml.skin.LineParam;
import znaishaded.net.sourceforge.plantuml.skin.Pragma;
import znaishaded.net.sourceforge.plantuml.skin.SkinParam;
import znaishaded.net.sourceforge.plantuml.skin.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.PName;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.style.StyleSignature;
import znaishaded.net.sourceforge.plantuml.style.StyleSignatureBasic;
import znaishaded.net.sourceforge.plantuml.svek.BaseFile;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.Cluster;
import znaishaded.net.sourceforge.plantuml.svek.ClusterHeader;
import znaishaded.net.sourceforge.plantuml.svek.DotStringFactory;
import znaishaded.net.sourceforge.plantuml.svek.EmptySvgException;
import znaishaded.net.sourceforge.plantuml.svek.EntityImageDegenerated;
import znaishaded.net.sourceforge.plantuml.svek.EntityImageProtected;
import znaishaded.net.sourceforge.plantuml.svek.GraphvizCrash;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Margins;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.SvekLine;
import znaishaded.net.sourceforge.plantuml.svek.SvekNode;
import znaishaded.net.sourceforge.plantuml.svek.SvekResult;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageActivity;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageArcCircle;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageAssociation;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageAssociationPoint;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageBranch;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageCircleEnd;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageCircleStart;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageClass;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageDeepHistory;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageDescription;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageEmptyPackage;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageGroup;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageJson;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageLollipopInterface;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageMap;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageNote;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageObject;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImagePort;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImagePseudoState;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageState;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageState2;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageStateEmptyDescription;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageSynchroBar;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageTips;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageUseCase;
import znaishaded.net.sourceforge.plantuml.text.BackSlash;
import znaishaded.net.sourceforge.plantuml.text.Guillemet;
import znaishaded.net.sourceforge.plantuml.utils.Log;

public final class GeneralImageBuilder {
    private final DotData dotData;
    private final EntityFactory entityFactory;
    private final UmlSource source;
    private final Pragma pragma;
    private final boolean strictUmlStyle;
    private Map<String, Double> maxX;
    private final StringBounder stringBounder;
    private final SName styleName;

    public static IEntityImage createEntityImageBlock(Entity leaf, ISkinParam skinParam, boolean isHideEmptyDescriptionForState, PortionShower portionShower, Bibliotekon bibliotekon, GraphvizVersion graphvizVersion, UmlDiagramType umlDiagramType, Collection<Link> links) {
        IEntityImage result = GeneralImageBuilder.createEntityImageBlockInternal(leaf, skinParam, isHideEmptyDescriptionForState, portionShower, bibliotekon, graphvizVersion, umlDiagramType, links);
        return result;
    }

    private static IEntityImage createEntityImageBlockInternal(Entity leaf, ISkinParam skinParam, boolean isHideEmptyDescriptionForState, PortionShower portionShower, Bibliotekon bibliotekon, GraphvizVersion graphvizVersion, UmlDiagramType umlDiagramType, Collection<Link> links) {
        if (leaf.isRemoved()) {
            throw new IllegalStateException();
        }
        if (leaf.getLeafType().isLikeClass()) {
            EntityImageClass entityImageClass = new EntityImageClass(leaf, skinParam, portionShower);
            Neighborhood neighborhood = leaf.getNeighborhood();
            if (neighborhood != null) {
                return new EntityImageProtected(entityImageClass, 20.0, neighborhood, bibliotekon);
            }
            return entityImageClass;
        }
        if (leaf.getLeafType() == LeafType.NOTE) {
            return new EntityImageNote(leaf, skinParam, umlDiagramType);
        }
        if (leaf.getLeafType() == LeafType.ACTIVITY) {
            return new EntityImageActivity(leaf, skinParam, bibliotekon);
        }
        if (leaf.getLeafType() == LeafType.PORTIN || leaf.getLeafType() == LeafType.PORTOUT) {
            Cluster parent = bibliotekon.getCluster(leaf.getParentContainer());
            return new EntityImagePort(leaf, skinParam, parent, bibliotekon, umlDiagramType.getStyleName());
        }
        if (leaf.getLeafType() == LeafType.STATE) {
            if (leaf.getEntityPosition() != EntityPosition.NORMAL) {
                Cluster stateParent = bibliotekon.getCluster(leaf.getParentContainer());
                return new EntityImageStateBorder(leaf, skinParam, stateParent, bibliotekon, umlDiagramType.getStyleName());
            }
            if (isHideEmptyDescriptionForState && leaf.getBodier().getRawBody().size() == 0) {
                return new EntityImageStateEmptyDescription(leaf, skinParam);
            }
            if (leaf.getStereotype() != null && "<<sdlreceive>>".equals(leaf.getStereotype().getLabel(Guillemet.DOUBLE_COMPARATOR))) {
                return new EntityImageState2(leaf, skinParam, umlDiagramType.getStyleName());
            }
            return new EntityImageState(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.CIRCLE_START) {
            return new EntityImageCircleStart(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.CIRCLE_END) {
            return new EntityImageCircleEnd(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.BRANCH || leaf.getLeafType() == LeafType.STATE_CHOICE) {
            return new EntityImageBranch(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.LOLLIPOP_FULL || leaf.getLeafType() == LeafType.LOLLIPOP_HALF) {
            return new EntityImageLollipopInterface(leaf, skinParam, umlDiagramType.getStyleName());
        }
        if (leaf.getLeafType() == LeafType.CIRCLE) {
            return new EntityImageDescription(leaf, skinParam, portionShower, links, umlDiagramType.getStyleName(), bibliotekon);
        }
        if (leaf.getLeafType() == LeafType.DESCRIPTION) {
            return new EntityImageDescription(leaf, skinParam, portionShower, links, umlDiagramType.getStyleName(), bibliotekon);
        }
        if (leaf.getLeafType() == LeafType.USECASE) {
            return new EntityImageUseCase(leaf, skinParam, portionShower);
        }
        if (leaf.getLeafType() == LeafType.USECASE_BUSINESS) {
            return new EntityImageUseCase(leaf, skinParam, portionShower);
        }
        if (leaf.getLeafType() == LeafType.OBJECT) {
            return new EntityImageObject(leaf, skinParam, portionShower);
        }
        if (leaf.getLeafType() == LeafType.MAP) {
            return new EntityImageMap(leaf, skinParam, portionShower);
        }
        if (leaf.getLeafType() == LeafType.JSON) {
            return new EntityImageJson(leaf, skinParam, portionShower);
        }
        if (leaf.getLeafType() == LeafType.SYNCHRO_BAR || leaf.getLeafType() == LeafType.STATE_FORK_JOIN) {
            return new EntityImageSynchroBar(leaf, skinParam, umlDiagramType.getStyleName());
        }
        if (leaf.getLeafType() == LeafType.ARC_CIRCLE) {
            return new EntityImageArcCircle(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.POINT_FOR_ASSOCIATION) {
            return new EntityImageAssociationPoint(leaf, skinParam);
        }
        if (leaf.isGroup()) {
            return new EntityImageGroup(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.EMPTY_PACKAGE) {
            if (leaf.getUSymbol() != null) {
                return new EntityImageDescription(leaf, skinParam, portionShower, links, umlDiagramType.getStyleName(), bibliotekon);
            }
            return new EntityImageEmptyPackage(leaf, skinParam, portionShower, umlDiagramType.getStyleName());
        }
        if (leaf.getLeafType() == LeafType.ASSOCIATION) {
            return new EntityImageAssociation(leaf, skinParam, umlDiagramType.getStyleName());
        }
        if (leaf.getLeafType() == LeafType.PSEUDO_STATE) {
            return new EntityImagePseudoState(leaf, skinParam, umlDiagramType.getStyleName());
        }
        if (leaf.getLeafType() == LeafType.DEEP_HISTORY) {
            return new EntityImageDeepHistory(leaf, skinParam, umlDiagramType.getStyleName());
        }
        if (leaf.getLeafType() == LeafType.TIPS) {
            return new EntityImageTips(leaf, skinParam, bibliotekon, umlDiagramType);
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isMachineOrSpecification()) {
            return new EntityImageMachine(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isDesignedOrSolved()) {
            return new EntityImageDesignedDomain(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.REQUIREMENT) {
            return new EntityImageRequirement(leaf, skinParam);
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isLexicalOrGiven()) {
            return new EntityImageDomain(leaf, skinParam, 'X');
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isCausal()) {
            return new EntityImageDomain(leaf, skinParam, 'C');
        }
        if (leaf.getLeafType() == LeafType.DOMAIN && leaf.getStereotype() != null && leaf.getStereotype().isBiddableOrUncertain()) {
            return new EntityImageDomain(leaf, skinParam, 'B');
        }
        if (leaf.getLeafType() == LeafType.DOMAIN) {
            return new EntityImageDomain(leaf, skinParam, 'P');
        }
        throw new UnsupportedOperationException(leaf.getLeafType().toString());
    }

    public static UStroke getForcedStroke(Stereotype stereotype, ISkinParam skinParam) {
        UStroke stroke = skinParam.getThickness(LineParam.packageBorder, stereotype);
        if (stroke == null) {
            stroke = UStroke.withThickness(1.5);
        }
        return stroke;
    }

    public GeneralImageBuilder(DotData dotData, EntityFactory entityFactory, UmlSource source, Pragma pragma, StringBounder stringBounder, SName styleName) {
        this.dotData = dotData;
        this.styleName = styleName;
        this.entityFactory = entityFactory;
        this.source = source;
        this.pragma = pragma;
        this.stringBounder = stringBounder;
        this.strictUmlStyle = dotData.getSkinParam().strictUmlStyle();
    }

    public final StyleSignature getDefaultStyleDefinitionArrow(Stereotype stereotype) {
        StyleSignature result = StyleSignatureBasic.of(SName.root, SName.element, this.styleName, SName.arrow);
        if (stereotype != null) {
            result = result.withTOBECHANGED(stereotype);
        }
        return result;
    }

    private boolean isOpalisable(Entity entity) {
        if (this.strictUmlStyle) {
            return false;
        }
        if (entity.isGroup()) {
            return false;
        }
        if (entity.getLeafType() != LeafType.NOTE) {
            return false;
        }
        Link single = this.onlyOneLink(entity);
        if (single == null) {
            return false;
        }
        return single.getOther(entity).getLeafType() != LeafType.NOTE;
    }

    private HColor getBackcolor() {
        Style style = StyleSignatureBasic.of(SName.root, SName.document).getMergedStyle(this.dotData.getSkinParam().getCurrentStyleBuilder());
        return style.value(PName.BackGroundColor).asColor(this.dotData.getSkinParam().getIHtmlColorSet());
    }

    public IEntityImage buildImage(BaseFile basefile, String[] dotStrings, boolean fileFormatOptionIsDebugSvek) {
        String svg;
        Entity single;
        Object group;
        if (this.dotData.isDegeneratedWithFewEntities(0)) {
            return new EntityImageSimpleEmpty(this.dotData.getSkinParam().getBackgroundColor());
        }
        if (this.dotData.isDegeneratedWithFewEntities(1) && this.dotData.getUmlDiagramType() != UmlDiagramType.STATE && ((Entity)(group = (single = this.dotData.getLeafs().iterator().next()).getParentContainer())).isRoot() && !(single.getUSymbol() instanceof USymbolHexagon)) {
            IEntityImage tmp = GeneralImageBuilder.createEntityImageBlock(single, this.dotData.getSkinParam(), this.dotData.isHideEmptyDescriptionForState(), this.dotData, null, null, this.dotData.getUmlDiagramType(), this.dotData.getLinks());
            return new EntityImageDegenerated(tmp, this.getBackcolor());
        }
        this.dotData.removeIrrelevantSametail();
        DotStringFactory dotStringFactory = new DotStringFactory(this.stringBounder, this.dotData);
        this.printGroups(dotStringFactory, this.dotData.getRootGroup());
        this.printEntities(dotStringFactory, this.getUnpackagedEntities());
        for (Link link : this.dotData.getLinks()) {
            if (link.isRemoved()) continue;
            try {
                SvekNode other;
                SvekNode node;
                ISkinParam skinParam = this.dotData.getSkinParam();
                FontConfiguration labelFont = this.getFontForLink(link, skinParam);
                SvekLine line = new SvekLine(link, dotStringFactory.getColorSequence(), skinParam, this.stringBounder, labelFont, dotStringFactory.getBibliotekon(), this.pragma, dotStringFactory.getGraphvizVersion());
                dotStringFactory.getBibliotekon().addLine(line);
                if (this.isOpalisable(link.getEntity1())) {
                    node = dotStringFactory.getBibliotekon().getNode(link.getEntity1());
                    other = dotStringFactory.getBibliotekon().getNode(link.getEntity2());
                    if (other == null) continue;
                    ((EntityImageNote)node.getImage()).setOpaleLine(line, node, other);
                    line.setOpale(true);
                    continue;
                }
                if (!this.isOpalisable(link.getEntity2())) continue;
                node = dotStringFactory.getBibliotekon().getNode(link.getEntity2());
                other = dotStringFactory.getBibliotekon().getNode(link.getEntity1());
                if (other == null) continue;
                ((EntityImageNote)node.getImage()).setOpaleLine(line, node, other);
                line.setOpale(true);
            }
            catch (IllegalStateException e) {
                Logme.error(e);
            }
        }
        if (dotStringFactory.illegalDotExe()) {
            return this.error(dotStringFactory.getDotExe());
        }
        if (basefile == null && (fileFormatOptionIsDebugSvek || this.isSvekTrace()) && (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE || SecurityUtils.getSecurityProfile() == SecurityProfile.LEGACY || SecurityUtils.getSecurityProfile() == SecurityProfile.SANDBOX)) {
            basefile = new BaseFile(null);
        }
        try {
            svg = dotStringFactory.getSvg(basefile, dotStrings);
        }
        catch (IOException e) {
            return new GraphvizCrash(this.source.getPlainString(BackSlash.lineSeparator()), GraphvizUtils.graphviz244onWindows(), e);
        }
        if (svg.length() == 0) {
            return new GraphvizCrash(this.source.getPlainString(BackSlash.lineSeparator()), GraphvizUtils.graphviz244onWindows(), new EmptySvgException());
        }
        String graphvizVersion = this.extractGraphvizVersion(svg);
        try {
            dotStringFactory.solve(this.dotData.getEntityFactory(), svg);
            SvekResult result = new SvekResult(this.dotData, dotStringFactory);
            this.maxX = dotStringFactory.getBibliotekon().getMaxX();
            return result;
        }
        catch (Exception e) {
            Log.error("Exception " + e);
            throw new UnparsableGraphvizException(e, graphvizVersion, svg, this.source.getPlainString(BackSlash.lineSeparator()));
        }
    }

    private FontConfiguration getFontForLink(Link link, ISkinParam skinParam) {
        Style style = this.getDefaultStyleDefinitionArrow(link.getStereotype()).getMergedStyle(link.getStyleBuilder());
        return style.getFontConfiguration(skinParam.getIHtmlColorSet());
    }

    private boolean isSvekTrace() {
        String value = this.pragma.getValue("svek_trace");
        return "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    private String extractGraphvizVersion(String svg) {
        Pattern pGraph = Pattern.compile("(?mi)!-- generated by graphviz(.*)");
        Matcher mGraph = pGraph.matcher(svg);
        if (mGraph.find()) {
            return StringUtils.trin(mGraph.group(1));
        }
        return null;
    }

    private Link onlyOneLink(Entity ent) {
        Link single = null;
        for (Link link : this.dotData.getLinks()) {
            if (link.isInvis() || !link.contains(ent)) continue;
            if (single != null) {
                return null;
            }
            single = link;
        }
        return single;
    }

    private IEntityImage error(File dotExe) {
        ArrayList<String> msg = new ArrayList<String>();
        msg.add("Dot Executable: " + dotExe);
        ExeState exeState = ExeState.checkFile(dotExe);
        msg.add(exeState.getTextMessage());
        msg.add("Cannot find Graphviz. You should try");
        msg.add(" ");
        msg.add("@startuml");
        msg.add("testdot");
        msg.add("@enduml");
        msg.add(" ");
        msg.add(" or ");
        msg.add(" ");
        msg.add("java -jar plantuml.jar -testdot");
        msg.add(" ");
        return GraphicStrings.createForError(msg, false);
    }

    private void printEntities(DotStringFactory dotStringFactory, Collection<Entity> entities2) {
        for (Entity ent : entities2) {
            if (ent.isRemoved()) continue;
            this.printEntity(dotStringFactory, ent);
        }
    }

    private void printEntity(DotStringFactory dotStringFactory, Entity ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage image = this.printEntityInternal(dotStringFactory, ent);
        SvekNode node = dotStringFactory.getBibliotekon().createNode(ent, image, dotStringFactory.getColorSequence(), this.stringBounder);
        dotStringFactory.addNode(node);
    }

    private IEntityImage printEntityInternal(DotStringFactory dotStringFactory, Entity ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        if (ent.getSvekImage() == null) {
            ISkinParam skinParam = this.dotData.getSkinParam();
            if (skinParam.sameClassWidth()) {
                double width = this.getMaxWidth();
                ((SkinParam)skinParam).setParamSameClassWidth(width);
            }
            return GeneralImageBuilder.createEntityImageBlock(ent, skinParam, this.dotData.isHideEmptyDescriptionForState(), this.dotData, dotStringFactory.getBibliotekon(), dotStringFactory.getGraphvizVersion(), this.dotData.getUmlDiagramType(), this.dotData.getLinks());
        }
        return ent.getSvekImage();
    }

    private double getMaxWidth() {
        double result = 0.0;
        for (Entity ent : this.dotData.getLeafs()) {
            EntityImageClass im;
            double w;
            if (!ent.getLeafType().isLikeClass() || !((w = (im = new EntityImageClass(ent, this.dotData.getSkinParam(), this.dotData)).calculateDimension(this.stringBounder).getWidth()) > result)) continue;
            result = w;
        }
        return result;
    }

    private Collection<Entity> getUnpackagedEntities() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity ent : this.dotData.getLeafs()) {
            if (this.dotData.getTopParent() != ent.getParentContainer()) continue;
            result.add(ent);
        }
        return result;
    }

    private void printGroups(DotStringFactory dotStringFactory, Entity parent) {
        Collection<Entity> groups = this.dotData.getGroupHierarchy().getChildrenGroups(parent);
        for (Entity g2 : groups) {
            if (g2.isRemoved()) continue;
            if (this.dotData.isEmpty(g2) && g2.getGroupType() == GroupType.PACKAGE) {
                g2.muteToType(LeafType.EMPTY_PACKAGE);
                this.printEntity(dotStringFactory, g2);
                continue;
            }
            this.printGroup(dotStringFactory, g2);
        }
    }

    private void printGroup(DotStringFactory dotStringFactory, Entity g2) {
        if (g2.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        ClusterHeader clusterHeader = new ClusterHeader(g2, this.dotData.getSkinParam(), this.dotData, this.stringBounder);
        dotStringFactory.openCluster(g2, clusterHeader);
        this.printEntities(dotStringFactory, g2.leafs());
        this.printGroups(dotStringFactory, g2);
        dotStringFactory.closeCluster();
    }

    public String getWarningOrError(int warningOrError) {
        if (this.maxX == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Double> ent : this.maxX.entrySet()) {
            if (!(ent.getValue() > (double)warningOrError)) continue;
            sb.append(ent.getKey() + " is overpassing the width limit.");
            sb.append("\n");
        }
        return sb.length() == 0 ? "" : sb.toString();
    }

    static class EntityImageSimpleEmpty
    implements IEntityImage {
        private final HColor backColor;

        EntityImageSimpleEmpty(HColor backColor) {
            this.backColor = backColor;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public HColor getBackcolor() {
            return this.backColor;
        }

        @Override
        public XDimension2D calculateDimension(StringBounder stringBounder) {
            return new XDimension2D(10.0, 10.0);
        }

        @Override
        public MinMax getMinMax(StringBounder stringBounder) {
            return MinMax.fromDim(this.calculateDimension(stringBounder));
        }

        @Override
        public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
            return null;
        }

        @Override
        public void drawU(UGraphic ug) {
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.RECTANGLE;
        }

        @Override
        public Margins getShield(StringBounder stringBounder) {
            return Margins.NONE;
        }

        @Override
        public double getOverscanX(StringBounder stringBounder) {
            return 0.0;
        }

        @Override
        public MagneticBorder getMagneticBorder() {
            return new MagneticBorderNone();
        }
    }
}

