/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class TFunctionSignature {
    private final String functionName;
    private final int nbArg;
    private final Set<String> namedArguments;

    public TFunctionSignature(String functionName, int nbArg) {
        this(functionName, nbArg, Collections.emptySet());
    }

    public TFunctionSignature(String functionName, int nbArg, Set<String> namedArguments) {
        this.functionName = Objects.requireNonNull(functionName);
        this.nbArg = nbArg;
        this.namedArguments = namedArguments;
    }

    public boolean sameFunctionNameAs(TFunctionSignature other) {
        return this.getFunctionName().equals(other.getFunctionName());
    }

    public String toString() {
        return this.functionName + "/" + this.nbArg + " " + this.namedArguments;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.functionName.hashCode();
        result = 31 * result + this.nbArg;
        return result;
    }

    public boolean equals(Object obj) {
        TFunctionSignature other = (TFunctionSignature)obj;
        return this.functionName.equals(other.functionName) && this.nbArg == other.nbArg;
    }

    public final String getFunctionName() {
        return this.functionName;
    }

    public final int getNbArg() {
        return this.nbArg;
    }

    public final Set<String> getNamedArguments() {
        return this.namedArguments;
    }
}

