/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.json.JsonArray;
import znaishaded.net.sourceforge.plantuml.json.JsonObject;
import znaishaded.net.sourceforge.plantuml.json.JsonValue;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TFunctionSignature;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.expression.TValue;
import znaishaded.net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public class Size
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%size", 1);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 1;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> values, Map<String, TValue> named) throws EaterException, EaterExceptionLocated {
        TValue value = values.get(0);
        if (value.isNumber()) {
            return TValue.fromInt(0);
        }
        if (value.isString()) {
            return TValue.fromInt(value.toString().length());
        }
        JsonValue json = value.toJson();
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            return TValue.fromInt(array.size());
        }
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            return TValue.fromInt(object.size());
        }
        return TValue.fromInt(0);
    }
}

