/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram.command;

import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Trim;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Player;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;
import znaishaded.net.sourceforge.plantuml.utils.Position;

public class CommandNoteLong
extends CommandMultilines2<TimingDiagram> {
    public CommandNoteLong() {
        super(CommandNoteLong.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    @Override
    public String getPatternEnd() {
        return "^end[%s]?note$";
    }

    @Override
    protected CommandExecutionResult executeNow(TimingDiagram diagram, BlocLines lines) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        String code = line0.get("CODE", 0);
        Player player = diagram.getPlayer(code);
        if (player == null) {
            return CommandExecutionResult.error("Unkown \"" + code + "\"");
        }
        Display note = lines.toDisplay();
        TimeTick now = diagram.getNow();
        player.addNote(now, note, Position.fromString(line0.get("POSITION", 0)));
        return CommandExecutionResult.ok();
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNoteLong.class.getName(), RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(top|bottom)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("of"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([\\p{L}_][%pLN_.]*)"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }
}

