/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.api;

import java.nio.file.Path;
import java.util.Collections;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.structure.AnchorIds;
import org.testingisdocumenting.znai.structure.DocStructure;

class ApiParametersAnchors {
    private ApiParametersAnchors() {
    }

    static void registerLocalAnchors(ComponentsRegistry componentsRegistry, Path markupPath, ApiParameters apiParameters) {
        DocStructure docStructure = componentsRegistry.docStructure();
        apiParameters.collectAllAnchors().forEach(anchorId -> docStructure.registerLocalAnchors(markupPath, new AnchorIds((String)anchorId, Collections.emptyList())));
    }

    static String anchorIdFromNameAndPrefix(String prefix, String name) {
        String sanitizeAnchorId = ApiParametersAnchors.sanitizeAnchorId(name);
        if (sanitizeAnchorId.isEmpty()) {
            return prefix;
        }
        return prefix + (prefix.isEmpty() ? "" : "_") + sanitizeAnchorId;
    }

    static String sanitizeAnchorId(String anchorId) {
        return anchorId.replace('.', '_').replaceAll("[\\\\*<> ]", "");
    }
}

