/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.cli;

import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.cli.CliCommandPropsAndValidation;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public class CliCommandIncludePlugin
implements IncludePlugin {
    private String command;
    private ResourcesResolver resourcesResolver;
    private String commandFile;

    @Override
    public String id() {
        return "cli-command";
    }

    @Override
    public IncludePlugin create() {
        return new CliCommandIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.resourcesResolver = componentsRegistry.resourceResolver();
        this.command = this.extractCommand(pluginParams);
        Map<String, Object> props = CliCommandPropsAndValidation.createProps(this.command, this.command, pluginParams.getOpts());
        return PluginResult.docElement("CliCommand", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.commandFile != null && !this.commandFile.isEmpty() ? Stream.of(AuxiliaryFile.builtTime(this.resourcesResolver.fullPath(this.commandFile))) : Stream.empty();
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.HIGH.text(this.command);
    }

    private String extractCommand(PluginParams pluginParams) {
        String commandAsFreeParam = pluginParams.getFreeParam().trim();
        if (!commandAsFreeParam.isEmpty()) {
            return commandAsFreeParam;
        }
        PluginParamsOpts opts = pluginParams.getOpts();
        this.commandFile = opts.get("commandFile", "");
        if (!this.commandFile.isEmpty()) {
            return this.resourcesResolver.textContent(this.commandFile);
        }
        return opts.getRequiredString("command");
    }
}

