/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.paramtypes;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

class CommonTypeValidation {
    CommonTypeValidation() {
    }

    static boolean matchString(Object value) {
        return value instanceof CharSequence;
    }

    static boolean matchStringOrNull(Object value) {
        return value == null || value instanceof CharSequence;
    }

    static boolean matchNumber(Object value) {
        return value instanceof Number;
    }

    static boolean matchStringOrNumber(Object value) {
        return CommonTypeValidation.matchString(value) || CommonTypeValidation.matchNumber(value);
    }

    static boolean matchBoolean(Object value) {
        return value instanceof Boolean;
    }

    static boolean matchObject(Object value) {
        return value instanceof Map;
    }

    static boolean matchListOrSingleString(Object value) {
        return CommonTypeValidation.matchListOrSingleValue(value, CommonTypeValidation::matchString);
    }

    static boolean matchListOrSingleNumber(Object value) {
        return CommonTypeValidation.matchListOrSingleValue(value, CommonTypeValidation::matchNumber);
    }

    static boolean matchListOrSingleStringWithNulls(Object value) {
        return CommonTypeValidation.matchListOrSingleValue(value, CommonTypeValidation::matchStringOrNull);
    }

    static boolean matchListOrSingleStringOrNumber(Object value) {
        return CommonTypeValidation.matchListOrSingleValue(value, CommonTypeValidation::matchStringOrNumber);
    }

    static boolean matchListOfAny(Object value) {
        return value instanceof List;
    }

    static boolean matchListOrSingleValue(Object value, Predicate<Object> predicate) {
        if (predicate.test(value)) {
            return true;
        }
        if (!(value instanceof List)) {
            return false;
        }
        List listValue = (List)value;
        return listValue.stream().allMatch(predicate);
    }
}

