/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.structure;

import java.util.Arrays;
import java.util.List;
import org.testingisdocumenting.znai.structure.TableOfContents;
import org.testingisdocumenting.znai.structure.TocGenerator;
import org.testingisdocumenting.znai.structure.TocNameAndOpts;
import org.testingisdocumenting.znai.utils.FilePathUtils;

public class PlainTextTocGenerator
implements TocGenerator {
    private final String defaultExtension;

    public PlainTextTocGenerator(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    @Override
    public TableOfContents generate(String textContent) {
        return new Parser(this.defaultExtension, textContent).parse();
    }

    private static class Parser {
        public static final String INDENTATION = "    ";
        private final List<String> lines;
        private TocNameAndOpts currentChapter;
        private final TableOfContents toc;

        public Parser(String defaultExtension, String nestedText) {
            this.lines = Arrays.asList(nestedText.replace("\r", "").split("\n"));
            this.toc = new TableOfContents(defaultExtension);
        }

        public TableOfContents parse() {
            this.lines.forEach(this::parse);
            return this.toc;
        }

        private void parse(String line) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) {
                return;
            }
            if (line.startsWith(INDENTATION)) {
                this.handlePageEntry(trimmedLine);
            } else if (line.startsWith(" ")) {
                this.handleSyntaxError();
            } else if (this.hasFileExtension(trimmedLine)) {
                this.handleStandalonePageEntry(trimmedLine);
            } else {
                this.handleChapterEntry(trimmedLine);
            }
        }

        private void handleSyntaxError() {
            throw new IllegalArgumentException("toc line should either start with " + INDENTATION.length() + " spaces to denote page file name, or start without spaces to denote chapter dir name or standalone page (with file extension)");
        }

        private void handleChapterEntry(String trimmedLine) {
            this.currentChapter = new TocNameAndOpts(trimmedLine);
        }

        private void handlePageEntry(String line) {
            if (this.currentChapter == null) {
                throw new IllegalArgumentException("chapter is not specified, use a line without indentation to specify a chapter");
            }
            this.toc.addTocItem(this.currentChapter, new TocNameAndOpts(line));
        }

        private boolean hasFileExtension(String line) {
            TocNameAndOpts nameAndOpts = new TocNameAndOpts(line);
            String name = nameAndOpts.getGivenName();
            return !FilePathUtils.fileExtension(name).isEmpty();
        }

        private void handleStandalonePageEntry(String line) {
            this.toc.addTocItem(new TocNameAndOpts(""), new TocNameAndOpts(line));
        }
    }
}

