/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.helpers;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.JacksonUtils;
import znaishaded.com.github.fge.jackson.JsonNumEquivalence;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.google.common.base.Equivalence;
import znaishaded.com.google.common.collect.Maps;

public abstract class DependenciesSyntaxChecker
extends AbstractSyntaxChecker {
    protected static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquivalence.getInstance();
    protected final EnumSet<NodeType> dependencyTypes;

    protected DependenciesSyntaxChecker(NodeType ... depTypes) {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
        this.dependencyTypes = EnumSet.of(NodeType.OBJECT, depTypes);
    }

    @Override
    protected final void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        TreeMap<String, JsonNode> map = Maps.newTreeMap();
        map.putAll(JacksonUtils.asMap(node));
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isObject()) {
                pointers.add(JsonPointer.of(this.keyword, key));
                continue;
            }
            this.checkDependency(report, bundle, (String)entry.getKey(), tree);
        }
    }

    protected abstract void checkDependency(ProcessingReport var1, MessageBundle var2, String var3, SchemaTree var4) throws ProcessingException;
}

