/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.google.i18n.phonenumbers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import znaishaded.com.google.i18n.phonenumbers.CountryCodeToRegionCodeMap;
import znaishaded.com.google.i18n.phonenumbers.MetadataManager;
import znaishaded.com.google.i18n.phonenumbers.PhoneNumberUtil;
import znaishaded.com.google.i18n.phonenumbers.Phonemetadata;
import znaishaded.com.google.i18n.phonenumbers.Phonenumber;
import znaishaded.com.google.i18n.phonenumbers.internal.MatcherApi;
import znaishaded.com.google.i18n.phonenumbers.internal.RegexBasedMatcher;

public class ShortNumberInfo {
    private static final Logger logger = Logger.getLogger(ShortNumberInfo.class.getName());
    private static final ShortNumberInfo INSTANCE = new ShortNumberInfo(RegexBasedMatcher.create());
    private static final Set<String> REGIONS_WHERE_EMERGENCY_NUMBERS_MUST_BE_EXACT = new HashSet<String>();
    private final MatcherApi matcherApi;
    private final Map<Integer, List<String>> countryCallingCodeToRegionCodeMap;

    public static ShortNumberInfo getInstance() {
        return INSTANCE;
    }

    ShortNumberInfo(MatcherApi matcherApi) {
        this.matcherApi = matcherApi;
        this.countryCallingCodeToRegionCodeMap = CountryCodeToRegionCodeMap.getCountryCodeToRegionCodeMap();
    }

    private List<String> getRegionCodesForCountryCode(int countryCallingCode) {
        ArrayList regionCodes = this.countryCallingCodeToRegionCodeMap.get(countryCallingCode);
        return Collections.unmodifiableList(regionCodes == null ? new ArrayList(0) : regionCodes);
    }

    private boolean regionDialingFromMatchesNumber(Phonenumber.PhoneNumber number, String regionDialingFrom) {
        List<String> regionCodes = this.getRegionCodesForCountryCode(number.getCountryCode());
        return regionCodes.contains(regionDialingFrom);
    }

    public boolean isPossibleShortNumberForRegion(Phonenumber.PhoneNumber number, String regionDialingFrom) {
        if (!this.regionDialingFromMatchesNumber(number, regionDialingFrom)) {
            return false;
        }
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion(regionDialingFrom);
        if (phoneMetadata == null) {
            return false;
        }
        int numberLength = ShortNumberInfo.getNationalSignificantNumber(number).length();
        return phoneMetadata.getGeneralDesc().getPossibleLengthList().contains(numberLength);
    }

    public boolean isPossibleShortNumber(Phonenumber.PhoneNumber number) {
        List<String> regionCodes = this.getRegionCodesForCountryCode(number.getCountryCode());
        int shortNumberLength = ShortNumberInfo.getNationalSignificantNumber(number).length();
        for (String region : regionCodes) {
            Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion(region);
            if (phoneMetadata == null || !phoneMetadata.getGeneralDesc().getPossibleLengthList().contains(shortNumberLength)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidShortNumberForRegion(Phonenumber.PhoneNumber number, String regionDialingFrom) {
        Phonemetadata.PhoneNumberDesc generalDesc;
        if (!this.regionDialingFromMatchesNumber(number, regionDialingFrom)) {
            return false;
        }
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion(regionDialingFrom);
        if (phoneMetadata == null) {
            return false;
        }
        String shortNumber = ShortNumberInfo.getNationalSignificantNumber(number);
        if (!this.matchesPossibleNumberAndNationalNumber(shortNumber, generalDesc = phoneMetadata.getGeneralDesc())) {
            return false;
        }
        Phonemetadata.PhoneNumberDesc shortNumberDesc = phoneMetadata.getShortCode();
        return this.matchesPossibleNumberAndNationalNumber(shortNumber, shortNumberDesc);
    }

    public boolean isValidShortNumber(Phonenumber.PhoneNumber number) {
        List<String> regionCodes = this.getRegionCodesForCountryCode(number.getCountryCode());
        String regionCode = this.getRegionCodeForShortNumberFromRegionList(number, regionCodes);
        if (regionCodes.size() > 1 && regionCode != null) {
            return true;
        }
        return this.isValidShortNumberForRegion(number, regionCode);
    }

    public ShortNumberCost getExpectedCostForRegion(Phonenumber.PhoneNumber number, String regionDialingFrom) {
        if (!this.regionDialingFromMatchesNumber(number, regionDialingFrom)) {
            return ShortNumberCost.UNKNOWN_COST;
        }
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion(regionDialingFrom);
        if (phoneMetadata == null) {
            return ShortNumberCost.UNKNOWN_COST;
        }
        String shortNumber = ShortNumberInfo.getNationalSignificantNumber(number);
        if (!phoneMetadata.getGeneralDesc().getPossibleLengthList().contains(shortNumber.length())) {
            return ShortNumberCost.UNKNOWN_COST;
        }
        if (this.matchesPossibleNumberAndNationalNumber(shortNumber, phoneMetadata.getPremiumRate())) {
            return ShortNumberCost.PREMIUM_RATE;
        }
        if (this.matchesPossibleNumberAndNationalNumber(shortNumber, phoneMetadata.getStandardRate())) {
            return ShortNumberCost.STANDARD_RATE;
        }
        if (this.matchesPossibleNumberAndNationalNumber(shortNumber, phoneMetadata.getTollFree())) {
            return ShortNumberCost.TOLL_FREE;
        }
        if (this.isEmergencyNumber(shortNumber, regionDialingFrom)) {
            return ShortNumberCost.TOLL_FREE;
        }
        return ShortNumberCost.UNKNOWN_COST;
    }

    public ShortNumberCost getExpectedCost(Phonenumber.PhoneNumber number) {
        List<String> regionCodes = this.getRegionCodesForCountryCode(number.getCountryCode());
        if (regionCodes.size() == 0) {
            return ShortNumberCost.UNKNOWN_COST;
        }
        if (regionCodes.size() == 1) {
            return this.getExpectedCostForRegion(number, regionCodes.get(0));
        }
        ShortNumberCost cost = ShortNumberCost.TOLL_FREE;
        block6: for (String regionCode : regionCodes) {
            ShortNumberCost costForRegion = this.getExpectedCostForRegion(number, regionCode);
            switch (costForRegion) {
                case PREMIUM_RATE: {
                    return ShortNumberCost.PREMIUM_RATE;
                }
                case UNKNOWN_COST: {
                    cost = ShortNumberCost.UNKNOWN_COST;
                    continue block6;
                }
                case STANDARD_RATE: {
                    if (cost == ShortNumberCost.UNKNOWN_COST) continue block6;
                    cost = ShortNumberCost.STANDARD_RATE;
                    continue block6;
                }
                case TOLL_FREE: {
                    continue block6;
                }
            }
            logger.log(Level.SEVERE, "Unrecognised cost for region: " + (Object)((Object)costForRegion));
        }
        return cost;
    }

    private String getRegionCodeForShortNumberFromRegionList(Phonenumber.PhoneNumber number, List<String> regionCodes) {
        if (regionCodes.size() == 0) {
            return null;
        }
        if (regionCodes.size() == 1) {
            return regionCodes.get(0);
        }
        String nationalNumber = ShortNumberInfo.getNationalSignificantNumber(number);
        for (String regionCode : regionCodes) {
            Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion(regionCode);
            if (phoneMetadata == null || !this.matchesPossibleNumberAndNationalNumber(nationalNumber, phoneMetadata.getShortCode())) continue;
            return regionCode;
        }
        return null;
    }

    Set<String> getSupportedRegions() {
        return MetadataManager.getSupportedShortNumberRegions();
    }

    String getExampleShortNumber(String regionCode) {
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion(regionCode);
        if (phoneMetadata == null) {
            return "";
        }
        Phonemetadata.PhoneNumberDesc desc = phoneMetadata.getShortCode();
        if (desc.hasExampleNumber()) {
            return desc.getExampleNumber();
        }
        return "";
    }

    String getExampleShortNumberForCost(String regionCode, ShortNumberCost cost) {
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion(regionCode);
        if (phoneMetadata == null) {
            return "";
        }
        Phonemetadata.PhoneNumberDesc desc = null;
        switch (cost) {
            case TOLL_FREE: {
                desc = phoneMetadata.getTollFree();
                break;
            }
            case STANDARD_RATE: {
                desc = phoneMetadata.getStandardRate();
                break;
            }
            case PREMIUM_RATE: {
                desc = phoneMetadata.getPremiumRate();
                break;
            }
        }
        if (desc != null && desc.hasExampleNumber()) {
            return desc.getExampleNumber();
        }
        return "";
    }

    public boolean connectsToEmergencyNumber(String number, String regionCode) {
        return this.matchesEmergencyNumberHelper(number, regionCode, true);
    }

    public boolean isEmergencyNumber(CharSequence number, String regionCode) {
        return this.matchesEmergencyNumberHelper(number, regionCode, false);
    }

    private boolean matchesEmergencyNumberHelper(CharSequence number, String regionCode, boolean allowPrefixMatch) {
        CharSequence possibleNumber = PhoneNumberUtil.extractPossibleNumber(number);
        if (PhoneNumberUtil.PLUS_CHARS_PATTERN.matcher(possibleNumber).lookingAt()) {
            return false;
        }
        Phonemetadata.PhoneMetadata metadata = MetadataManager.getShortNumberMetadataForRegion(regionCode);
        if (metadata == null || !metadata.hasEmergency()) {
            return false;
        }
        String normalizedNumber = PhoneNumberUtil.normalizeDigitsOnly(possibleNumber);
        boolean allowPrefixMatchForRegion = allowPrefixMatch && !REGIONS_WHERE_EMERGENCY_NUMBERS_MUST_BE_EXACT.contains(regionCode);
        return this.matcherApi.matchNationalNumber(normalizedNumber, metadata.getEmergency(), allowPrefixMatchForRegion);
    }

    public boolean isCarrierSpecific(Phonenumber.PhoneNumber number) {
        List<String> regionCodes = this.getRegionCodesForCountryCode(number.getCountryCode());
        String regionCode = this.getRegionCodeForShortNumberFromRegionList(number, regionCodes);
        String nationalNumber = ShortNumberInfo.getNationalSignificantNumber(number);
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion(regionCode);
        return phoneMetadata != null && this.matchesPossibleNumberAndNationalNumber(nationalNumber, phoneMetadata.getCarrierSpecific());
    }

    public boolean isCarrierSpecificForRegion(Phonenumber.PhoneNumber number, String regionDialingFrom) {
        if (!this.regionDialingFromMatchesNumber(number, regionDialingFrom)) {
            return false;
        }
        String nationalNumber = ShortNumberInfo.getNationalSignificantNumber(number);
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion(regionDialingFrom);
        return phoneMetadata != null && this.matchesPossibleNumberAndNationalNumber(nationalNumber, phoneMetadata.getCarrierSpecific());
    }

    public boolean isSmsServiceForRegion(Phonenumber.PhoneNumber number, String regionDialingFrom) {
        if (!this.regionDialingFromMatchesNumber(number, regionDialingFrom)) {
            return false;
        }
        Phonemetadata.PhoneMetadata phoneMetadata = MetadataManager.getShortNumberMetadataForRegion(regionDialingFrom);
        return phoneMetadata != null && this.matchesPossibleNumberAndNationalNumber(ShortNumberInfo.getNationalSignificantNumber(number), phoneMetadata.getSmsServices());
    }

    private static String getNationalSignificantNumber(Phonenumber.PhoneNumber number) {
        StringBuilder nationalNumber = new StringBuilder();
        if (number.isItalianLeadingZero()) {
            char[] zeros = new char[number.getNumberOfLeadingZeros()];
            Arrays.fill(zeros, '0');
            nationalNumber.append(new String(zeros));
        }
        nationalNumber.append(number.getNationalNumber());
        return nationalNumber.toString();
    }

    private boolean matchesPossibleNumberAndNationalNumber(String number, Phonemetadata.PhoneNumberDesc numberDesc) {
        if (numberDesc.getPossibleLengthCount() > 0 && !numberDesc.getPossibleLengthList().contains(number.length())) {
            return false;
        }
        return this.matcherApi.matchNationalNumber(number, numberDesc, false);
    }

    static {
        REGIONS_WHERE_EMERGENCY_NUMBERS_MUST_BE_EXACT.add("BR");
        REGIONS_WHERE_EMERGENCY_NUMBERS_MUST_BE_EXACT.add("CL");
        REGIONS_WHERE_EMERGENCY_NUMBERS_MUST_BE_EXACT.add("NI");
    }

    public static enum ShortNumberCost {
        TOLL_FREE,
        STANDARD_RATE,
        PREMIUM_RATE,
        UNKNOWN_COST;

    }
}

