/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.util;

import znaishaded.com.fasterxml.jackson.annotation.JsonInclude;
import znaishaded.com.fasterxml.jackson.core.JsonFactory;
import znaishaded.com.fasterxml.jackson.databind.BeanDescription;
import znaishaded.com.fasterxml.jackson.databind.DeserializationFeature;
import znaishaded.com.fasterxml.jackson.databind.JsonSerializer;
import znaishaded.com.fasterxml.jackson.databind.Module;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.com.fasterxml.jackson.databind.SerializationConfig;
import znaishaded.com.fasterxml.jackson.databind.SerializationFeature;
import znaishaded.com.fasterxml.jackson.databind.module.SimpleModule;
import znaishaded.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import znaishaded.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import znaishaded.io.swagger.jackson.ModelSerializer;
import znaishaded.io.swagger.jackson.PropertySerializer;
import znaishaded.io.swagger.jackson.mixin.OperationResponseMixin;
import znaishaded.io.swagger.jackson.mixin.ResponseSchemaMixin;
import znaishaded.io.swagger.models.Model;
import znaishaded.io.swagger.models.Operation;
import znaishaded.io.swagger.models.Response;
import znaishaded.io.swagger.models.properties.Property;
import znaishaded.io.swagger.util.DeserializationModule;
import znaishaded.io.swagger.util.ReferenceSerializationConfigurer;

public class ObjectMapperFactory {
    public static ObjectMapper createJson(JsonFactory jsonFactory) {
        return ObjectMapperFactory.create(jsonFactory, true, true);
    }

    public static ObjectMapper createJson() {
        return ObjectMapperFactory.createJson(true, true);
    }

    public static ObjectMapper createJson(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(null, includePathDeserializer, includeResponseDeserializer);
    }

    public static ObjectMapper createYaml(YAMLFactory yamlFactory) {
        return ObjectMapperFactory.create(yamlFactory, true, true);
    }

    public static ObjectMapper createYaml() {
        return ObjectMapperFactory.createYaml(true, true);
    }

    public static ObjectMapper createYaml(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(new YAMLFactory(), includePathDeserializer, includeResponseDeserializer);
    }

    public static ObjectMapper create(JsonFactory jsonFactory, boolean includePathDeserializer, boolean includeResponseDeserializer) {
        ObjectMapper mapper = jsonFactory == null ? new ObjectMapper() : new ObjectMapper(jsonFactory);
        mapper.registerModule(new SimpleModule(){

            @Override
            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addBeanSerializerModifier(new BeanSerializerModifier(){

                    @Override
                    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription desc, JsonSerializer<?> serializer) {
                        if (Property.class.isAssignableFrom(desc.getBeanClass())) {
                            return new PropertySerializer(serializer);
                        }
                        if (Model.class.isAssignableFrom(desc.getBeanClass())) {
                            return new ModelSerializer(serializer);
                        }
                        return serializer;
                    }
                });
            }
        });
        DeserializationModule deserializerModule = new DeserializationModule(includePathDeserializer, includeResponseDeserializer);
        mapper.registerModule(deserializerModule);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.addMixIn(Response.class, ResponseSchemaMixin.class);
        mapper.addMixIn(Operation.class, OperationResponseMixin.class);
        ReferenceSerializationConfigurer.serializeAsComputedRef(mapper);
        return mapper;
    }
}

