/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.parser;

import znaishaded.com.fasterxml.jackson.annotation.JsonInclude;
import znaishaded.com.fasterxml.jackson.core.JsonFactory;
import znaishaded.com.fasterxml.jackson.core.JsonFactoryBuilder;
import znaishaded.com.fasterxml.jackson.core.StreamReadFeature;
import znaishaded.com.fasterxml.jackson.databind.DeserializationFeature;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.com.fasterxml.jackson.databind.SerializationFeature;
import znaishaded.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import znaishaded.com.fasterxml.jackson.dataformat.yaml.YAMLFactoryBuilder;
import znaishaded.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public class ObjectMapperFactory {
    public static ObjectMapper createJson() {
        return ObjectMapperFactory.createJson(true, true);
    }

    protected static ObjectMapper createJson(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(ObjectMapperFactory.createJsonFactory(), includePathDeserializer, includeResponseDeserializer);
    }

    public static ObjectMapper createYaml() {
        return ObjectMapperFactory.createYaml(true, true);
    }

    protected static ObjectMapper createYaml(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(ObjectMapperFactory.createYamlFactory(), includePathDeserializer, includeResponseDeserializer);
    }

    private static ObjectMapper create(JsonFactory jsonFactory, boolean includePathDeserializer, boolean includeResponseDeserializer) {
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.registerModule(new JavaTimeModule());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    private static JsonFactory createJsonFactory() {
        return ((JsonFactoryBuilder)new JsonFactoryBuilder().enable(StreamReadFeature.STRICT_DUPLICATE_DETECTION)).build();
    }

    private static JsonFactory createYamlFactory() {
        return ((YAMLFactoryBuilder)YAMLFactory.builder().enable(StreamReadFeature.STRICT_DUPLICATE_DETECTION)).build();
    }
}

