/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.impl;

import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Context;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Promise;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.impl.VertxImpl;
import znaishaded.io.vertx.core.impl.WorkerExecutorInternal;
import znaishaded.io.vertx.core.impl.WorkerPool;
import znaishaded.io.vertx.core.spi.metrics.Metrics;
import znaishaded.io.vertx.core.spi.metrics.MetricsProvider;
import znaishaded.io.vertx.core.spi.metrics.PoolMetrics;

class WorkerExecutorImpl
implements MetricsProvider,
WorkerExecutorInternal {
    private final Context ctx;
    private final VertxImpl.SharedWorkerPool pool;
    private boolean closed;

    public WorkerExecutorImpl(Context ctx, VertxImpl.SharedWorkerPool pool) {
        this.ctx = ctx;
        this.pool = pool;
    }

    @Override
    public Metrics getMetrics() {
        return this.pool.metrics();
    }

    @Override
    public boolean isMetricsEnabled() {
        PoolMetrics metrics = this.pool.metrics();
        return metrics != null;
    }

    @Override
    public Vertx vertx() {
        return this.ctx.owner();
    }

    @Override
    public WorkerPool getPool() {
        return this.pool;
    }

    @Override
    public synchronized <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
        if (this.closed) {
            throw new IllegalStateException("Worker executor closed");
        }
        ContextImpl context = (ContextImpl)this.ctx.owner().getOrCreateContext();
        context.executeBlocking(blockingCodeHandler, asyncResultHandler, this.pool.executor(), ordered ? context.orderedTasks : null, this.pool.metrics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        WorkerExecutorImpl workerExecutorImpl = this;
        synchronized (workerExecutorImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.ctx.removeCloseHook(this);
        this.pool.release();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.close();
        completionHandler.handle(Future.succeededFuture());
    }
}

