/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import znaishaded.net.sourceforge.plantuml.Annotated;
import znaishaded.net.sourceforge.plantuml.AnnotatedBuilder;
import znaishaded.net.sourceforge.plantuml.abel.DisplayPositioned;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.svek.DecorateEntityImage;

public class AnnotatedWorker {
    private final Annotated annotated;
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    private final AnnotatedBuilder builder;

    public AnnotatedWorker(Annotated annotated, ISkinParam skinParam, StringBounder stringBounder, AnnotatedBuilder builder) {
        this.annotated = annotated;
        this.skinParam = skinParam;
        this.stringBounder = stringBounder;
        this.builder = builder;
    }

    public TextBlock addAdd(TextBlock result) {
        result = this.builder.decoreWithFrame(result);
        result = this.addLegend(result);
        result = this.addTitle(result);
        result = this.addCaption(result);
        result = this.builder.addHeaderAndFooter(result);
        return result;
    }

    public TextBlock addLegend(TextBlock original) {
        DisplayPositioned legend = this.annotated.getLegend();
        if (legend.isNull()) {
            return original;
        }
        return DecorateEntityImage.add(original, this.builder.getLegend(), legend.getHorizontalAlignment(), legend.getVerticalAlignment());
    }

    public TextBlock addTitle(TextBlock original) {
        DisplayPositioned title = (DisplayPositioned)this.annotated.getTitle();
        if (title.isNull()) {
            return original;
        }
        return DecorateEntityImage.addTop(original, this.builder.getTitle(), HorizontalAlignment.CENTER);
    }

    private TextBlock addCaption(TextBlock original) {
        DisplayPositioned caption = this.annotated.getCaption();
        if (caption.isNull()) {
            return original;
        }
        return DecorateEntityImage.addBottom(original, this.builder.getCaption(), HorizontalAlignment.CENTER);
    }
}

