/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.TitledDiagram;
import znaishaded.net.sourceforge.plantuml.abel.DisplayPositioned;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Trim;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;

public class CommandMultilinesLegend
extends CommandMultilines2<TitledDiagram> {
    public static final CommandMultilinesLegend ME = new CommandMultilinesLegend();

    private CommandMultilinesLegend() {
        super(CommandMultilinesLegend.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandMultilinesLegend.class.getName(), RegexLeaf.start(), new RegexLeaf("legend"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("VALIGN", "(top|bottom)"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("ALIGN", "(left|right|center)"))), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "^end[%s]?legend$";
    }

    @Override
    protected CommandExecutionResult executeNow(TitledDiagram diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trimSmart(1);
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String align = line0.get("ALIGN", 0);
        String valign = line0.get("VALIGN", 0);
        lines = lines.subExtract(1, 1);
        Display strings = (lines = lines.removeEmptyColumns()).toDisplay();
        if (strings.size() > 0) {
            VerticalAlignment valignment = VerticalAlignment.fromString(valign);
            HorizontalAlignment alignment = HorizontalAlignment.fromString(align);
            if (alignment == null) {
                alignment = HorizontalAlignment.CENTER;
            }
            diagram.setLegend(DisplayPositioned.single(strings.replaceBackslashT(), alignment, valignment));
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("No legend defined");
    }
}

