/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.emoji;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import znaishaded.net.sourceforge.plantuml.emoji.SvgNanoParser;
import znaishaded.net.sourceforge.plantuml.emoji.data.Dummy;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.log.Logme;

public class Emoji {
    private static final Map<String, Emoji> ALL = new HashMap<String, Emoji>();
    private SvgNanoParser nano;
    private final String unicode;
    private final String shortcut;

    public static Map<String, Emoji> getAll() {
        return Collections.unmodifiableMap(new TreeMap<String, Emoji>(ALL));
    }

    private Emoji(String unicode) {
        int x = unicode.indexOf(59);
        if (x == -1) {
            this.shortcut = null;
        } else {
            this.shortcut = unicode.substring(x + 1);
            ALL.put(this.shortcut, this);
            unicode = unicode.substring(0, x);
        }
        this.unicode = unicode;
        ALL.put(unicode, this);
    }

    public static String pattern() {
        StringBuilder sb = new StringBuilder("\\<(#\\w+)?:(");
        for (String s2 : ALL.keySet()) {
            if (!sb.toString().endsWith("(")) {
                sb.append("|");
            }
            sb.append(s2);
        }
        sb.append("):\\>");
        return sb.toString();
    }

    public static Emoji retrieve(String name) {
        return ALL.get(name.toLowerCase());
    }

    private synchronized void loadIfNeed() throws IOException {
        if (this.nano != null) {
            return;
        }
        ArrayList<String> data = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Dummy.class.getResourceAsStream(this.unicode + ".svg")));){
            String singleLine = br.readLine();
            data.add(singleLine);
        }
        this.nano = new SvgNanoParser(data, false);
    }

    public void drawU(UGraphic ug, double scale, HColor colorForMonochrome) {
        try {
            this.loadIfNeed();
        }
        catch (IOException e) {
            Logme.error(e);
        }
        this.nano.drawU(ug, scale, colorForMonochrome);
    }

    public String getShortcut() {
        return this.shortcut;
    }

    static {
        InputStream is = Dummy.class.getResourceAsStream("emoji.txt");
        if (is != null) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String s2 = null;
                while ((s2 = br.readLine()) != null) {
                    new Emoji(s2);
                }
            }
            catch (IOException e) {
                Logme.error(e);
            }
        }
    }
}

