/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.geom;

import znaishaded.net.sourceforge.plantuml.klimt.geom.XLine2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class XRectangle2D {
    public final double x;
    public final double y;
    public final double width;
    public final double height;

    public XRectangle2D(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getCenterX() {
        return this.x + this.width / 2.0;
    }

    public double getCenterY() {
        return this.y + this.height / 2.0;
    }

    public double getMinX() {
        return this.x;
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getMinY() {
        return this.y;
    }

    public double getMaxY() {
        return this.y + this.height;
    }

    public boolean intersects(XRectangle2D other) {
        return this.intersects(other.getX(), other.getY(), other.getWidth(), other.getHeight());
    }

    private boolean intersects(double x, double y, double w, double h2) {
        return w > 0.0 && h2 > 0.0 && this.getWidth() > 0.0 && this.getHeight() > 0.0 && x < this.getX() + this.getWidth() && x + w > this.getX() && y < this.getY() + this.getHeight() && y + h2 > this.getY();
    }

    public boolean contains(XPoint2D point) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(double xp, double yp) {
        if (this.width <= 0.0 || this.height <= 0.0) {
            throw new IllegalStateException();
        }
        return xp >= this.getMinX() && xp < this.getMaxX() && yp >= this.getMinY() && yp < this.getMaxY();
    }

    public XPoint2D intersect(XLine2D line) {
        XPoint2D a = new XPoint2D(this.x, this.y);
        XPoint2D b = new XPoint2D(this.x + this.width, this.y);
        XPoint2D c = new XPoint2D(this.x + this.width, this.y + this.height);
        XPoint2D d = new XPoint2D(this.x, this.y + this.height);
        XLine2D line1 = XLine2D.line(a, b);
        XLine2D line2 = XLine2D.line(b, c);
        XLine2D line3 = XLine2D.line(c, d);
        XLine2D line4 = XLine2D.line(d, a);
        XPoint2D result = line.intersect(line1);
        if (result != null) {
            return result;
        }
        result = line.intersect(line2);
        if (result != null) {
            return result;
        }
        result = line.intersect(line3);
        if (result != null) {
            return result;
        }
        result = line.intersect(line4);
        if (result != null) {
            return result;
        }
        return null;
    }
}

