/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.openiconic;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.openiconic.SvgCommand;

public class SvgCommandLetter
implements SvgCommand {
    private final char letter;

    public SvgCommandLetter(String letter) {
        if (!letter.matches("[mlhvzsacqtMLHVZSACQT]")) {
            throw new IllegalArgumentException(letter);
        }
        this.letter = letter.charAt(0);
    }

    public String toString() {
        return " " + this.letter;
    }

    @Override
    public String toSvg() {
        return "" + this.letter;
    }

    public int argumentNumber() {
        switch (StringUtils.goLowerCase(this.letter)) {
            case 'l': 
            case 'm': 
            case 't': {
                return 2;
            }
            case 'h': 
            case 'v': {
                return 1;
            }
            case 'z': {
                return 0;
            }
            case 'c': {
                return 6;
            }
            case 'q': 
            case 's': {
                return 4;
            }
            case 'a': {
                return 7;
            }
        }
        throw new UnsupportedOperationException("" + this.letter);
    }

    public boolean isUpperCase() {
        return Character.isUpperCase(this.letter);
    }

    public boolean is(char c) {
        return this.letter == c;
    }

    public char getLetter() {
        return this.letter;
    }

    public SvgCommandLetter implicit() {
        if (this.letter == 'm') {
            return new SvgCommandLetter("l");
        }
        if (this.letter == 'M') {
            return new SvgCommandLetter("L");
        }
        return this;
    }
}

