/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLine;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.text.TLineType;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterStartsub;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;

public class Sub {
    private final String name;
    private final List<StringLocated> lines = new ArrayList<StringLocated>();

    public Sub(String name) {
        this.name = name;
    }

    public String toString() {
        return super.toString() + " " + this.name;
    }

    public void add(StringLocated s2) {
        this.lines.add(s2);
    }

    public final List<StringLocated> lines() {
        return Collections.unmodifiableList(this.lines);
    }

    public static Sub fromFile(ReadLine reader, String blocname, TContext context, TMemory memory) throws IOException, EaterException {
        Sub result = null;
        StringLocated s2 = null;
        boolean skip = false;
        while ((s2 = reader.readLine()) != null) {
            TLineType type = s2.getTrimmed().getType();
            if (type == TLineType.STARTSUB) {
                EaterStartsub eater = new EaterStartsub(s2.getTrimmed());
                eater.analyze(context, memory);
                if (!eater.getSubname().equals(blocname)) continue;
                skip = false;
                if (result != null) continue;
                result = new Sub(blocname);
                continue;
            }
            if (type == TLineType.ENDSUB && result != null) {
                skip = true;
            }
            if (result == null || skip) continue;
            result.add(s2);
        }
        return result;
    }
}

