/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.factory;

import java.util.ArrayList;
import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.salt.DataSource;
import znaishaded.net.sourceforge.plantuml.salt.SaltDictionary;
import znaishaded.net.sourceforge.plantuml.salt.Terminated;
import znaishaded.net.sourceforge.plantuml.salt.element.Element;
import znaishaded.net.sourceforge.plantuml.salt.factory.ElementFactory;

public abstract class AbstractElementFactoryComplex
implements ElementFactory {
    private final DataSource dataSource;
    private final Collection<ElementFactory> factories = new ArrayList<ElementFactory>();
    private final SaltDictionary dictionary;

    public AbstractElementFactoryComplex(DataSource dataSource, SaltDictionary dictionary) {
        this.dataSource = dataSource;
        this.dictionary = dictionary;
    }

    public final void addFactory(ElementFactory factory) {
        this.factories.add(factory);
    }

    protected Terminated<Element> getNextElement() {
        for (ElementFactory factory : this.factories) {
            if (!factory.ready()) continue;
            return factory.create();
        }
        throw new IllegalStateException(this.dataSource.peek(0).getElement());
    }

    protected final DataSource getDataSource() {
        return this.dataSource;
    }

    protected final SaltDictionary getDictionary() {
        return this.dictionary;
    }
}

