/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.command;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Reference;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import znaishaded.net.sourceforge.plantuml.url.Url;
import znaishaded.net.sourceforge.plantuml.url.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.url.UrlMode;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;

public class CommandReferenceMultilinesOverSeveral
extends CommandMultilines<SequenceDiagram> {
    public CommandReferenceMultilinesOverSeveral() {
        super(CommandReferenceMultilinesOverSeveral.getConcat().getPattern());
    }

    private static RegexConcat getConcat() {
        return RegexConcat.build(CommandReferenceMultilinesOverSeveral.class.getName(), RegexLeaf.start(), new RegexLeaf("ref"), new RegexLeaf("REF", "(#\\w+)?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("over"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("PARTS", "((?:[%pLN_.@]+|[%g][^%g]+[%g])(?:[%s]*,[%s]*(?:[%pLN_.@]+|[%g][^%g]+[%g]))*)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("URL", "(\\[\\[.*?\\]\\])")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("UNUSED", "(#\\w+)?"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "^end[%s]?(ref)?$";
    }

    @Override
    public CommandExecutionResult execute(SequenceDiagram diagram, BlocLines lines) throws NoSuchColorException {
        String firstLine = lines.getFirst().getTrimmed().getString();
        RegexResult arg = CommandReferenceMultilinesOverSeveral.getConcat().matcher(firstLine);
        if (arg == null) {
            return CommandExecutionResult.error("Cannot parse line " + firstLine);
        }
        String s1 = arg.get("REF", 0);
        HColor backColorElement = s1 == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s1);
        List<String> participants = StringUtils.splitComma(arg.get("PARTS", 0));
        ArrayList<Participant> p = new ArrayList<Participant>();
        for (String s2 : participants) {
            p.add(diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(s2)));
        }
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        Display strings = lines.toDisplay();
        String url = arg.get("URL", 0);
        UrlBuilder b = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
        Url u = null;
        if (url != null) {
            u = b.getUrl(url);
        }
        HColor backColorGeneral = null;
        Reference ref = new Reference(p, u, strings, backColorGeneral, backColorElement, diagram.getSkinParam().getCurrentStyleBuilder());
        diagram.addReference(ref);
        return CommandExecutionResult.ok();
    }
}

