/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Message;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TimeHook;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ArrowComponent;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.LineParam;
import znaishaded.net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;

public class CommunicationTile
extends AbstractTile {
    private final LivingSpace livingSpace1;
    private final LivingSpace livingSpace2;
    private final LivingSpaces livingSpaces;
    private final Message message;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final YGauge yGauge;
    public static final double LIVE_DELTA_SIZE = 5.0;

    @Override
    public Event getEvent() {
        return this.message;
    }

    public String toString() {
        return super.toString() + " " + this.message;
    }

    public CommunicationTile(StringBounder stringBounder, LivingSpaces livingSpaces, Message message, Rose skin, ISkinParam skinParam, YGauge currentY) {
        super(stringBounder, currentY);
        this.livingSpace1 = livingSpaces.get(message.getParticipant1());
        this.livingSpace2 = livingSpaces.get(message.getParticipant2());
        this.livingSpaces = livingSpaces;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
        if (message.isCreate()) {
            this.livingSpace2.goCreate();
        }
        ArrowComponent comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        this.yGauge = message.isParallel() ? YGauge.create(currentY.getMin(), dim.getHeight()) : YGauge.create(currentY.getMax(), dim.getHeight());
    }

    @Override
    public YGauge getYGauge() {
        return this.yGauge;
    }

    public boolean isReverse(StringBounder stringBounder) {
        Real point1 = this.livingSpace1.getPosC(stringBounder);
        Real point2 = this.livingSpace2.getPosC(stringBounder);
        return point1.getCurrentValue() > point2.getCurrentValue();
    }

    private boolean isCreate() {
        return this.message.isCreate();
    }

    private double getArrowThickness() {
        UStroke result = this.skinParam.getThickness(LineParam.sequenceArrow, null);
        if (result == null) {
            return 1.0;
        }
        return result.getThickness();
    }

    private ArrowComponent getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        if (this.isReverse(stringBounder)) {
            arrowConfiguration = arrowConfiguration.reverse();
        }
        arrowConfiguration = arrowConfiguration.withThickness(this.getArrowThickness());
        return this.skin.createComponentArrow(this.message.getUsedStyles(), arrowConfiguration, this.skinParam, this.message.getLabelNumbered());
    }

    private ArrowComponent getComponentMulticast(StringBounder stringBounder, boolean reverse) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        if (reverse) {
            arrowConfiguration = arrowConfiguration.reverse();
        }
        arrowConfiguration = arrowConfiguration.withThickness(this.getArrowThickness());
        return this.skin.createComponentArrow(this.message.getUsedStyles(), arrowConfiguration, this.skinParam, Display.NULL);
    }

    @Override
    public double getContactPointRelative() {
        return this.getComponent(this.getStringBounder()).getYPoint(this.getStringBounder());
    }

    @Override
    protected final void callbackY_internal(TimeHook y) {
        super.callbackY_internal(y);
        if (this.message.isCreate()) {
            this.livingSpace2.goCreate(y.getValue());
        }
        AbstractComponentRoseArrow comp = (AbstractComponentRoseArrow)this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        double arrowY = comp.getStartPoint(this.getStringBounder(), dim).getY();
        this.livingSpace1.addStepForLivebox(this.getEvent(), y.getValue() + arrowY);
        this.livingSpace2.addStepForLivebox(this.getEvent(), y.getValue() + arrowY);
    }

    @Override
    public void drawU(UGraphic ug) {
        Area area;
        String anchor1 = this.message.getPart1Anchor();
        String anchor2 = this.message.getPart2Anchor();
        if (anchor1 != null || anchor2 != null) {
            return;
        }
        StringBounder stringBounder = ug.getStringBounder();
        ArrowComponent comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        double x1 = this.getPoint1(stringBounder).getCurrentValue();
        double x2 = this.getPoint2(stringBounder).getCurrentValue();
        this.drawMulticast(ug.apply(UTranslate.dy(comp.getPosArrow(stringBounder))));
        if (this.isReverse(stringBounder)) {
            int level1 = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level1 > 0) {
                x1 -= 5.0;
            }
            area = Area.create(x1 - (x2 += 5.0 * (double)level2), dim.getHeight());
            ug = ug.apply(UTranslate.dx(x2));
            if (this.isCreate()) {
                this.livingSpace2.drawHead(ug, (Context2D)((Object)ug), VerticalAlignment.TOP, HorizontalAlignment.RIGHT);
            }
        } else {
            int level1 = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level2 > 0) {
                level2 -= 2;
            }
            area = Area.create((x2 += 5.0 * (double)level2) - (x1 += 5.0 * (double)level1), dim.getHeight());
            ug = ug.apply(UTranslate.dx(x1));
            if (this.isCreate()) {
                this.livingSpace2.drawHead(ug.apply(UTranslate.dx(area.getDimensionToUse().getWidth())), (Context2D)((Object)ug), VerticalAlignment.TOP, HorizontalAlignment.LEFT);
            }
        }
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    private void drawMulticast(UGraphic ug) {
        if (this.message.getMulticast().size() == 0) {
            return;
        }
        StringBounder stringBounder = ug.getStringBounder();
        double x1 = this.getPoint1(stringBounder).getCurrentValue();
        double dy = 2.0;
        for (Participant participant : this.message.getMulticast()) {
            double x2 = this.livingSpaces.get(participant).getPosC(stringBounder).getCurrentValue();
            boolean reverse = x2 < x1;
            ArrowComponent comp = this.getComponentMulticast(stringBounder, reverse);
            XDimension2D dim = comp.getPreferredDimension(stringBounder);
            Area area = Area.create(Math.abs(x2 - x1), dim.getHeight());
            UGraphic ug2 = ug.apply(UTranslate.dx(Math.min(x1, x2))).apply(UTranslate.dy(dy));
            dy += 2.0;
            comp.drawU(ug2, area, (Context2D)((Object)ug2));
        }
    }

    @Override
    public double getPreferredHeight() {
        ArrowComponent comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        double height = dim.getHeight();
        if (this.isCreate()) {
            height = Math.max(height, this.livingSpace2.getHeadPreferredDimension(this.getStringBounder()).getHeight());
        }
        return height;
    }

    @Override
    public void addConstraints() {
        ArrowComponent comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        double width = dim.getWidth();
        Real point1 = this.getPoint1(this.getStringBounder());
        Real point2 = this.getPoint2(this.getStringBounder());
        if (this.isReverse(this.getStringBounder())) {
            int level1 = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level1 > 0) {
                point1 = point1.addFixed(-5.0);
            }
            point2 = point2.addFixed((double)level2 * 5.0);
            point1.ensureBiggerThan(point2.addFixed(width));
        } else {
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level2 > 0) {
                point2 = point2.addFixed(-5.0);
            }
            point2.ensureBiggerThan(point1.addFixed(width));
        }
    }

    private Real getPoint1(StringBounder stringBounder) {
        return this.livingSpace1.getPosC(stringBounder);
    }

    private Real getPoint2(StringBounder stringBounder) {
        if (this.message.isCreate()) {
            if (this.isReverse(stringBounder)) {
                return this.livingSpace2.getPosD(stringBounder);
            }
            return this.livingSpace2.getPosB(stringBounder);
        }
        return this.livingSpace2.getPosC(stringBounder);
    }

    @Override
    public Real getMinX() {
        if (this.isReverse(this.getStringBounder())) {
            return this.getPoint2(this.getStringBounder());
        }
        return this.getPoint1(this.getStringBounder());
    }

    @Override
    public Real getMaxX() {
        if (this.isReverse(this.getStringBounder())) {
            return this.getPoint1(this.getStringBounder());
        }
        return this.getPoint2(this.getStringBounder());
    }
}

