/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.tim.EaterException;
import znaishaded.net.sourceforge.plantuml.tim.EaterExceptionLocated;
import znaishaded.net.sourceforge.plantuml.tim.TContext;
import znaishaded.net.sourceforge.plantuml.tim.TFunctionSignature;
import znaishaded.net.sourceforge.plantuml.tim.TMemory;
import znaishaded.net.sourceforge.plantuml.tim.expression.TValue;
import znaishaded.net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public class Darken
extends SimpleReturnFunction {
    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%darken", 2);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 2;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> values, Map<String, TValue> named) throws EaterException, EaterExceptionLocated {
        String colorString = values.get(0).toString();
        int ratio = values.get(1).toInt();
        try {
            HColor color = HColorSet.instance().getColorLEGACY(colorString);
            color = color.darken(ratio);
            return TValue.fromString(color.asString());
        }
        catch (NoSuchColorException e) {
            throw EaterException.located("No such color");
        }
    }
}

