/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.utils;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;

public class StartUtils {
    public static final Pattern2 patternFilename = MyPattern.cmpile("^[@\\\\]start[^%s{}%g]+[%s{][%s%g]*([^%g]*?)[%s}%g]*$");
    public static final String PAUSE_PATTERN = "((?:\\W|\\<[^<>]*\\>)*)[@\\\\]unpause";
    public static final String START_PATTERN = "((?:[^\\w~]|\\<[^<>]*\\>)*)[@\\\\]start";
    private static final Pattern2 append = MyPattern.cmpile("^\\W*[@\\\\](append|a)\\b");

    public static String beforeStartUml(String s2) {
        boolean inside = false;
        for (int i = 0; i < s2.length(); ++i) {
            String tmp = s2.substring(i, s2.length());
            if (StartUtils.startsWithSymbolAnd("start", tmp)) {
                return s2.substring(0, i);
            }
            String single = s2.substring(i, i + 1);
            if (inside) {
                if (!single.equals(">")) continue;
                inside = false;
                continue;
            }
            if (single.equals("<")) {
                inside = true;
                continue;
            }
            if (!single.matches("[\\w~]")) continue;
            return null;
        }
        return null;
    }

    public static boolean isArobaseStartDiagram(String s2) {
        String s22 = StringUtils.trinNoTrace(s2);
        if (!s22.startsWith("@") && !s22.startsWith("\\")) {
            return false;
        }
        return DiagramType.getTypeFromArobaseStart(s22) != DiagramType.UNKNOWN;
    }

    public static boolean startsWithSymbolAnd(String value, StringLocated tmp) {
        return tmp.getString().startsWith("@" + value) || tmp.getString().startsWith("\\" + value);
    }

    public static boolean startsWithSymbolAnd(String value, String tmp) {
        return tmp.startsWith("@" + value) || tmp.startsWith("\\" + value);
    }

    public static boolean startOrEnd(StringLocated s2) {
        String s22 = StringUtils.trinNoTrace(s2.getString());
        if (!s22.startsWith("@") && !s22.startsWith("\\")) {
            return false;
        }
        return StartUtils.startsWithSymbolAnd("end", s22) || DiagramType.getTypeFromArobaseStart(s22) != DiagramType.UNKNOWN;
    }

    public static boolean isArobaseEndDiagram(String s2) {
        String s22 = StringUtils.trinNoTrace(s2);
        return StartUtils.startsWithSymbolAnd("end", s22);
    }

    public static boolean isArobasePauseDiagram(String s2) {
        String s22 = StringUtils.trinNoTrace(s2);
        return StartUtils.startsWithSymbolAnd("pause", s22);
    }

    public static boolean isArobaseUnpauseDiagram(String s2) {
        String s22 = StringUtils.trinNoTrace(s2);
        return StartUtils.startsWithSymbolAnd("unpause", s22);
    }

    public static boolean isExit(CharSequence s2) {
        String s22 = StringUtils.trinNoTrace(s2);
        return s22.equals("!exit");
    }

    public static StringLocated getPossibleAppend(StringLocated cs) {
        String s2 = cs.getString();
        Matcher2 m3 = append.matcher(s2);
        if (m3.find()) {
            String tmp = s2.substring(m3.group(0).length(), s2.length());
            return new StringLocated(StringUtils.trin(tmp), cs.getLocation(), cs.getPreprocessorError());
        }
        return null;
    }
}

