/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wbs;

import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.mindmap.IdeaShape;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.utils.Direction;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;
import znaishaded.net.sourceforge.plantuml.wbs.WBSDiagram;

public class CommandWBSItem
extends SingleLineCommand2<WBSDiagram> {
    public CommandWBSItem(int mode) {
        super(false, CommandWBSItem.getRegexConcat(mode));
    }

    static IRegex getRegexConcat(int mode) {
        if (mode == 0) {
            return RegexConcat.build(CommandWBSItem.class.getName() + mode, RegexLeaf.start(), new RegexLeaf("TYPE", "([ \t]*[*+-]+)"), new RegexOptional((IRegex)new RegexLeaf("BACKCOLOR", "\\[(#\\w+)\\]")), new RegexOptional((IRegex)new RegexLeaf("CODE", "\\(([%pLN_]+)\\)")), new RegexLeaf("SHAPE", "(_)?"), new RegexLeaf("DIRECTION", "([<>])?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("LABEL", "([^%s].*)"), RegexLeaf.end());
        }
        return RegexConcat.build(CommandWBSItem.class.getName() + mode, RegexLeaf.start(), new RegexLeaf("TYPE", "([ \t]*[*+-]+)"), new RegexOptional((IRegex)new RegexLeaf("BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf("SHAPE", "(_)?"), new RegexLeaf("DIRECTION", "([<>])?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("LABEL", "[%g](.*)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([%pLN_]+)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(WBSDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String type = arg.get("TYPE", 0);
        String label = arg.get("LABEL", 0);
        String code = arg.get("CODE", 0);
        String stringColor = arg.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColor(stringColor);
        }
        Direction dir = type.contains("-") ? Direction.LEFT : Direction.RIGHT;
        String direction = arg.get("DIRECTION", 0);
        if ("<".equals(direction)) {
            dir = Direction.LEFT;
        } else if (">".equals(direction)) {
            dir = Direction.RIGHT;
        }
        return diagram.addIdea(code, backColor, diagram.getSmartLevel(type), label, dir, IdeaShape.fromDesc(arg.get("SHAPE", 0)));
    }
}

