/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.wire;

import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.UFont;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.wire.WArrowDirection;
import znaishaded.net.sourceforge.plantuml.wire.WLinkType;

public class WLinkVertical {
    private final UTranslate start;
    private final double destination;
    private final WLinkType type;
    private final WArrowDirection direction;
    private final HColor color;
    private final Display label;
    private final ISkinParam skinParam;

    public WLinkVertical(ISkinParam skinParam, UTranslate start, double destination, WLinkType type, WArrowDirection direction, HColor color, Display label) {
        this.start = start;
        this.destination = destination;
        this.skinParam = skinParam;
        this.direction = direction;
        this.type = type;
        this.label = label;
        this.color = color == null ? this.getBlack() : color;
    }

    private HColor getBlack() {
        return HColors.BLACK.withDark(HColors.WHITE);
    }

    private HColor getWhite() {
        return HColors.WHITE.withDark(HColors.BLACK);
    }

    private TextBlock getTextBlock() {
        FontConfiguration fontConfiguration = FontConfiguration.blackBlueTrue(UFont.sansSerif(10)).changeColor(this.color);
        return this.label.create(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam);
    }

    public void drawMe(UGraphic ug) {
        ug = ug.apply(this.color);
        if (this.type == WLinkType.NORMAL) {
            ug = ug.apply(this.color.bg());
            this.drawNormalArrow(ug);
        } else if (this.type == WLinkType.BUS) {
            ug = ug.apply(this.getWhite().bg());
            this.drawBusArrow(ug);
        }
    }

    private void drawBusArrow(UGraphic ug) {
        double dy = this.destination - this.start.getDy() - 2.0;
        UPath path = UPath.none();
        if (this.direction == WArrowDirection.NONE) {
            path.moveTo(0.0, 0.0);
            path.lineTo(0.0, dy);
            path.lineTo(10.0, dy);
            path.lineTo(10.0, 0.0);
            path.lineTo(0.0, 0.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dy(1.0))).draw(path);
        }
        if (this.direction == WArrowDirection.NORMAL) {
            path.moveTo(0.0, 0.0);
            path.lineTo(0.0, dy - 15.0);
            path.lineTo(-5.0, dy - 15.0);
            path.lineTo(5.0, dy);
            path.lineTo(15.0, dy - 15.0);
            path.lineTo(10.0, dy - 15.0);
            path.lineTo(10.0, 0.0);
            path.lineTo(0.0, 0.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dy(1.0))).draw(path);
        }
        if (this.direction == WArrowDirection.BOTH) {
            path.moveTo(5.0, 0.0);
            path.lineTo(-5.0, 15.0);
            path.lineTo(0.0, 15.0);
            path.lineTo(0.0, dy - 15.0);
            path.lineTo(-5.0, dy - 15.0);
            path.lineTo(5.0, dy);
            path.lineTo(15.0, dy - 15.0);
            path.lineTo(10.0, dy - 15.0);
            path.lineTo(10.0, 15.0);
            path.lineTo(15.0, 15.0);
            path.lineTo(5.0, 0.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dy(1.0))).draw(path);
        }
        if (this.direction == WArrowDirection.REVERSE) {
            path.moveTo(5.0, 0.0);
            path.lineTo(-5.0, 15.0);
            path.lineTo(0.0, 15.0);
            path.lineTo(0.0, dy);
            path.lineTo(10.0, dy);
            path.lineTo(10.0, 15.0);
            path.lineTo(15.0, 15.0);
            path.lineTo(5.0, 0.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dy(1.0))).draw(path);
        }
    }

    private void drawNormalArrow(UGraphic ug) {
        UPath path;
        double dy = this.destination - this.start.getDy() - 2.0;
        if (this.direction == WArrowDirection.BOTH || this.direction == WArrowDirection.NORMAL) {
            path = UPath.none();
            path.moveTo(0.0, 0.0);
            path.lineTo(5.0, -5.0);
            path.lineTo(-5.0, -5.0);
            path.lineTo(0.0, 0.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dy(dy))).draw(path);
        }
        if (this.direction == WArrowDirection.BOTH || this.direction == WArrowDirection.REVERSE) {
            path = UPath.none();
            path.moveTo(0.0, 0.0);
            path.lineTo(5.0, 5.0);
            path.lineTo(-5.0, 5.0);
            path.lineTo(0.0, 0.0);
            path.closePath();
            ug.apply(this.start.compose(UTranslate.dy(1.0))).draw(path);
        }
        ug.apply(this.start.compose(UTranslate.dy(1.0))).draw(ULine.vline(dy));
    }
}

