/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.core.factory;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.testmonkeys.maui.core.browser.Browser;
import org.testmonkeys.maui.core.elements.Component;
import org.testmonkeys.maui.core.factory.PageInitializer;
import org.testmonkeys.maui.core.factory.PageScanner;
import org.testmonkeys.maui.core.page.Page;
import org.testmonkeys.maui.core.utils.ReflectionUtils;
import org.testmonkeys.maui.pageobjects.PageAccessor;

public class PageFactory {
    private Browser browser;
    private PageScanner scanner;
    private Map<Class<? extends Page>, Page> cache;
    private String baseUrl;
    private PageInitializer pageInitializer;
    private ReflectionUtils reflectionUtils;

    public PageFactory(Browser browser, PageScanner scanner, String baseUrl) {
        this.browser = browser;
        this.scanner = scanner;
        this.baseUrl = baseUrl;
        this.cache = new HashMap<Class<? extends Page>, Page>();
        this.pageInitializer = new PageInitializer();
        this.reflectionUtils = new ReflectionUtils();
    }

    public Page createPage(String name) {
        Class<? extends Page> page = this.scanner.getPageByName(name);
        return this.createPage(page);
    }

    public <T extends Component> T getElement(Page page, String elementName) {
        List<Field> fields = ReflectionUtils.extractFieldsByPredicate(page.getClass(), field -> field.getName().equalsIgnoreCase(elementName));
        if (fields.isEmpty()) {
            return null;
        }
        fields.get(0).setAccessible(true);
        try {
            return (T)((Component)fields.get(0).get(page));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T extends Page> T createPage(Class<T> type) {
        Page cachedPage = this.cache.get(type);
        if (cachedPage != null) {
            return (T)((Page)type.cast(cachedPage));
        }
        PageAccessor pageAccessor = this.getPageAccessor(type);
        String url = this.baseUrl + pageAccessor.url();
        Page page = (Page)this.reflectionUtils.instantiate(type);
        page.setBrowser(this.browser);
        page.setName(pageAccessor.name());
        page.setUrl(url);
        this.pageInitializer.createPageContent(this.browser, page);
        this.cache.put(page.getClass(), page);
        return (T)page;
    }

    private <T extends Page> PageAccessor getPageAccessor(Class<T> type) {
        PageAccessor[] pageAccessors = (PageAccessor[])type.getAnnotationsByType(PageAccessor.class);
        if (pageAccessors.length != 1) {
            throw new RuntimeException("Page of type [" + type + "] has wrong number of PageAccessor annotations.");
        }
        return pageAccessors[0];
    }
}

