/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.core.factory;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Predicate;
import org.testmonkeys.maui.core.browser.Browser;
import org.testmonkeys.maui.core.elements.Component;
import org.testmonkeys.maui.core.elements.Module;
import org.testmonkeys.maui.core.elements.location.LocatesElements;
import org.testmonkeys.maui.core.elements.location.Locator;
import org.testmonkeys.maui.core.factory.LocatorProvider;
import org.testmonkeys.maui.core.utils.ReflectionUtils;
import org.testmonkeys.maui.pageobjects.ElementAccessor;
import org.testmonkeys.maui.pageobjects.elements.GroupComponent;

public class PageInitializer {
    private final LocatorProvider locatorProvider = new LocatorProvider();
    private final ReflectionUtils reflectionUtils = new ReflectionUtils();

    public <T extends LocatesElements> void createPageContent(Browser browser, T parent) {
        List<Field> elements = ReflectionUtils.extractFieldsByPredicate(parent.getClass(), this.isComponent());
        for (Field field : elements) {
            Component component = this.createComponent(browser, field, parent);
            this.setFieldValue(field, parent, component);
        }
    }

    private Component createComponent(Browser browser, Field field, LocatesElements parent) {
        Type[] params;
        ElementAccessor annotation = field.getAnnotation(ElementAccessor.class);
        Class<?> elementType = field.getType();
        Component component = (Component)this.reflectionUtils.instantiate(elementType);
        component.setBrowser(browser);
        component.setLocator(this.locatorProvider.getLocatorFromAnnotation(annotation));
        component.setParent(parent);
        component.setName(annotation.elementName());
        Type genericType = field.getGenericType();
        if (genericType != null && GroupComponent.class.equals(elementType) && (params = ((ParameterizedType)genericType).getActualTypeArguments()).length != 0) {
            Type genericParam = params[0];
            ((GroupComponent)component).setItemType(genericParam);
        }
        if (component instanceof Module) {
            this.createPageContent(browser, component);
        }
        return component;
    }

    public Component createComponent(Browser browser, Class<? extends Component> elementType, LocatesElements parent, Locator locator, String elementName) {
        Component component = this.reflectionUtils.instantiate(elementType);
        component.setBrowser(browser);
        component.setLocator(locator);
        component.setParent(parent);
        component.setName(elementName);
        if (component instanceof Module) {
            this.createPageContent(browser, component);
        }
        return component;
    }

    private Predicate<Field> isComponent() {
        return field -> Component.class.isAssignableFrom(field.getType());
    }

    private void setFieldValue(Field field, Object container, Object value) {
        field.setAccessible(true);
        try {
            field.set(container, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

