/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.core.factory;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.testmonkeys.maui.core.page.Page;
import org.testmonkeys.maui.core.utils.ReflectionUtils;
import org.testmonkeys.maui.pageobjects.ElementAccessor;
import org.testmonkeys.maui.pageobjects.PageAccessor;
import org.testmonkeys.maui.pageobjects.elements.AbstractComponent;

public class PageScanner {
    private String pagesPackage;

    public PageScanner(String pagesPackage) {
        this.pagesPackage = pagesPackage;
    }

    private Predicate<Class<?>> isPageWithName(String name) {
        return clazz -> clazz.getDeclaredAnnotation(PageAccessor.class).name().equals(name);
    }

    private Predicate<Field> isElement() {
        return field -> field.getType().getSuperclass().equals(AbstractComponent.class);
    }

    private Supplier pageWithNameNotFound(String name) {
        return () -> new RuntimeException("Could not find page with name [" + name + "]");
    }

    public Class<? extends Page> getPageByName(String name) {
        ConfigurationBuilder builder = new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)this.pagesPackage, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
        Reflections reflections = new Reflections((Configuration)builder);
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(PageAccessor.class);
        Optional<Class<?>> first = typesAnnotatedWith.stream().filter(this.isPageWithName(name)).findFirst();
        return first.orElseThrow(this.pageWithNameNotFound(name));
    }

    public <T extends AbstractComponent> T findPageElementByName(Page page, String name) {
        try {
            List<Field> fields = ReflectionUtils.extractFieldsByPredicate(page.getClass(), this.isElement());
            for (Field field : fields) {
                field.setAccessible(true);
                if (!field.getAnnotation(ElementAccessor.class).elementName().equalsIgnoreCase(name)) continue;
                return (T)((AbstractComponent)field.get(page));
            }
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Exception during parsing page " + page.getClass().getSimpleName(), e);
        }
    }
}

