/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.pageobjects.elements.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.testmonkeys.maui.core.elements.actions.ExecuteJSScript;
import org.testmonkeys.maui.pageobjects.elements.AbstractComponent;
import org.testmonkeys.maui.pageobjects.elements.html.HtmlAttribute;
import org.testmonkeys.maui.pageobjects.elements.html.JSInteractionException;

public class HtmlElement {
    private AbstractComponent component;

    public HtmlElement(AbstractComponent component) {
        this.component = component;
    }

    public List<HtmlAttribute> getAttributes() {
        Object result = new ExecuteJSScript(this.component, "/javaScript/htmlElement/getAttributes.js", new Object[0]).execute();
        ArrayList<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>();
        try {
            ArrayList elementAttributes = (ArrayList)result;
            for (Map elementAttribute : elementAttributes) {
                attributes.add(this.getAttribute(elementAttribute));
            }
        }
        catch (Exception e) {
            throw new JSInteractionException("Could not parse annotations", e);
        }
        return attributes;
    }

    private HtmlAttribute getAttribute(Map<String, String> attributeDetails) {
        HtmlAttribute attribute = new HtmlAttribute();
        if (!attributeDetails.containsKey("name")) {
            throw new JSInteractionException("Could not understand the attribute list");
        }
        attribute.setName(attributeDetails.get("name"));
        if (attributeDetails.containsKey("value")) {
            attribute.setValue(attributeDetails.get("value"));
        }
        return attribute;
    }

    public Map<String, String> getStyle() {
        Map result;
        Object jsResult = new ExecuteJSScript(this.component, "/javaScript/htmlElement/getComputedStyle.js", new Object[0]).execute();
        try {
            result = (Map)jsResult;
        }
        catch (ClassCastException e) {
            throw new JSInteractionException("Could not parse style object", e);
        }
        return result;
    }

    public String getStyle(String key) {
        Map<String, String> styles = this.getStyle();
        if (!styles.containsKey(key)) {
            return null;
        }
        return styles.get(key);
    }

    public String getInnerHtml() {
        Object jsResult = new ExecuteJSScript(this.component, "/javaScript/htmlElement/getInnerHtml.js", new Object[0]).execute();
        return (String)jsResult;
    }

    public void setInnerHtml(String value) {
        new ExecuteJSScript(this.component, "/javaScript/htmlElement/setInnerHtml.js", value).execute();
    }

    public String getOuterHtml() {
        Object jsResult = new ExecuteJSScript(this.component, "/javaScript/htmlElement/getOuterHtml.js", new Object[0]).execute();
        return (String)jsResult;
    }

    public void setOuterHtml(String value) {
        new ExecuteJSScript(this.component, "/javaScript/htmlElement/setOuterHtml.js", value).execute();
    }

    public String getTagName() {
        Object jsResult = new ExecuteJSScript(this.component, "/javaScript/htmlElement/getTagName.js", new Object[0]).execute();
        return (String)jsResult;
    }

    public boolean getHidden() {
        Object jsResult = new ExecuteJSScript(this.component, "/javaScript/htmlElement/getHidden.js", new Object[0]).execute();
        return (Boolean)jsResult;
    }

    public void setHidden(boolean value) {
        new ExecuteJSScript(this.component, "/javaScript/htmlElement/setHidden.js", value).execute();
    }

    public int getTabIndex() {
        Object jsResult = new ExecuteJSScript(this.component, "/javaScript/htmlElement/getTabIndex.js", new Object[0]).execute();
        return (int)((Long)jsResult).longValue();
    }

    public void setTabIndex(int value) {
        new ExecuteJSScript(this.component, "/javaScript/htmlElement/setTabIndex.js", value).execute();
    }

    public String getTitle() {
        Object jsResult = new ExecuteJSScript(this.component, "/javaScript/htmlElement/getTitle.js", new Object[0]).execute();
        return (String)jsResult;
    }

    public void setTitle(String value) {
        new ExecuteJSScript(this.component, "/javaScript/htmlElement/setTitle.js", value).execute();
    }

    public boolean getDraggable() {
        Object jsResult = new ExecuteJSScript(this.component, "/javaScript/htmlElement/getDraggable.js", new Object[0]).execute();
        return (Boolean)jsResult;
    }

    public void setDraggable(boolean value) {
        new ExecuteJSScript(this.component, "/javaScript/htmlElement/setDraggable.js", value).execute();
    }
}

