/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.core.elements.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.testmonkeys.maui.core.elements.Component;

public class ActionHooksContext {
    private static ActionHooksContext instance;
    private List<Consumer<Component>> beforeHooks = new ArrayList<Consumer<Component>>();
    private List<Consumer<Component>> afterHooks = new ArrayList<Consumer<Component>>();

    private ActionHooksContext() {
    }

    public static synchronized ActionHooksContext getContext() {
        if (instance == null) {
            instance = new ActionHooksContext();
        }
        return instance;
    }

    public void registerBeforeHook(Consumer<Component> predicate) {
        this.beforeHooks.add(predicate);
    }

    public void removeBeforeHook(Consumer<Component> predicate) {
        this.beforeHooks.remove(predicate);
    }

    public void registerAfterHook(Consumer<Component> predicate) {
        this.afterHooks.add(predicate);
    }

    public void removeAfterHook(Consumer<Component> predicate) {
        this.afterHooks.remove(predicate);
    }

    List<Consumer<Component>> getBeforeHooks() {
        return this.beforeHooks;
    }

    List<Consumer<Component>> getAfterHooks() {
        return this.afterHooks;
    }
}

